

--  ------------  Generated from [../../../Source/CommServer/Db/Function/cvEntitySearchGenerateTrigrams.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: cvEntitySearchGenerateTrigrams'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cvEntitySearchGenerateTrigrams]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[cvEntitySearchGenerateTrigrams]
  delete from GXDBVersions where name = 'cvEntitySearchGenerateTrigrams' and type = 5
END
GO

--- Generate trigrams from a string
CREATE FUNCTION cvEntitySearchGenerateTrigrams(@string nvarchar(255))
RETURNS table
WITH SCHEMABINDING
AS RETURN
    WITH
        N16 AS
        (
            SELECT V.v
            FROM
            (
                VALUES
                    (0),(0),(0),(0),(0),(0),(0),(0),
                    (0),(0),(0),(0),(0),(0),(0),(0)
            ) AS V (v)),
        -- Numbers table (256)
        Nums AS
        (
            SELECT n = ROW_NUMBER() OVER (ORDER BY A.v)
            FROM N16 AS A
            CROSS JOIN N16 AS B
        ),
        Trigrams AS
        (
            -- Every 3-character substring
            SELECT TOP (CASE WHEN LEN(@string) > 0 THEN LEN(@string) ELSE 0 END)
                trigram = SUBSTRING(@string, N.n, 3)
            FROM Nums AS N
            ORDER BY N.n
        )
    -- Remove duplicates
    SELECT DISTINCT
        T.trigram
    FROM Trigrams AS T


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [cvEntitySearchGenerateTrigrams]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'cvEntitySearchGenerateTrigrams' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'cvEntitySearchGenerateTrigrams',  '1.1.2.2', 'cvEntitySearchGenerateTrigrams', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
