

--  ------------  Generated from [../../../Source/CommServer/Db/Function/canManageEventSurvey.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: canManageEventSurvey'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[canManageEventSurvey]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[canManageEventSurvey]
  delete from GXDBVersions where name = 'canManageEventSurvey' and type = 5
END
GO

	CREATE FUNCTION canManageEventSurvey
	(
	 @i_userGuid nvarchar(256),
	 @i_EventId INTEGER,
	 @i_operation INTEGER = 3
	)
	RETURNS INTEGER
	AS
	BEGIN
        DECLARE @is_creator INT = 0
        DECLARE @is_allowed INT = 0
        IF @i_userGuid = '' OR @i_EventId = 0
  	        RETURN @is_allowed;
        -- check if creator of event
        IF EXISTS(select TOP 1 1 from CvEvents_Event WITH(NOLOCK) where EventId = @i_EventId and CreatedBy = @i_userGuid)
        BEGIN
            SET @is_creator = 1
            RETURN @is_creator;
        END
        IF @i_operation = 0 -- edit
        BEGIN
  	        IF EXISTS(select TOP 1 1 from CvEvents_Organizer WITH(NOLOCK) where EventId = @i_EventId and GroupUserGuid = @i_userGuid)
  	        BEGIN
  	        	SET @is_allowed = 1
  	        END
        END
        ELSE IF @i_operation = 1 -- delete
        BEGIN
  	        RETURN @is_creator;
        END
        ELSE IF @i_operation = 2 -- respond
        BEGIN
  	        IF EXISTS(select TOP 1 1 from CvEvents_Participant WITH(NOLOCK) where EventId = @i_EventId and GroupUserGuid = @i_userGuid)
  	        BEGIN
  	    	    SET @is_allowed = 1
  	        END
        END
        ELSE IF @i_operation = 3 -- view
        BEGIN
  	        IF EXISTS(select TOP 1 1 from CvEvents_Participant WITH(NOLOCK) where EventId = @i_EventId and GroupUserGuid = @i_userGuid)
                  OR EXISTS(select TOP 1 1 from CvEvents_Organizer WITH(NOLOCK) where EventId = @i_EventId and GroupUserGuid = @i_userGuid)
  	        BEGIN
  	    	    SET @is_allowed = 1
  	        END
        END
        RETURN @is_allowed;
    END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [canManageEventSurvey]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'canManageEventSurvey' AND revision = '')

  insert into GXDBVersions values(5, 'canManageEventSurvey',  '', 'canManageEventSurvey', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
