

--  ------------  Generated from [../../../Source/CommServer/Db/Function/archUncopiedMediaFn.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: archUncopiedMediaFn'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archUncopiedMediaFn]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[archUncopiedMediaFn]
  delete from GXDBVersions where name = 'archUncopiedMediaFn' and type = 5
END
GO

    	CREATE FUNCTION archUncopiedMediaFn(
    		@i_spId		INTEGER,
    		@i_copyId	INTEGER
    	)
    	RETURNS @STORAGE_SrcMediaInfoTbl TABLE (
    		PolicyId			INTEGER,
    		PolicyName			NVARCHAR(288),
    		CopyId				INTEGER,
    		CopyName			NVARCHAR(288),
    		TargetStream		INTEGER,
    		Media				NVARCHAR(288),
    		Library				NVARCHAR(288),
    		Location			NVARCHAR(1024),
    		UnCopiedData		BIGINT
    	)
    	AS
    	BEGIN

    		DECLARE @defCopyId  integer

    		IF @i_spId = 0
    		   SET @i_spId = (SELECT archGroupId FROM archGroupCopy WITH (NOLOCK) WHERE id = @i_copyId)

    		SET @defCopyId = (SELECT defaultCopy FROM archGroup WITH (NOLOCK) WHERE id = @i_spId)

    		DECLARE @tblAFC TABLE (
    			archFileId int, commCellId int, archCopyId int,
    			isValid int, streamNum int, physicalSize bigint,
    			sourceCopyId int, srcIsValid int, srcStreamNum int, srcPhysicalSize bigint,
    			primary key (archFileId, commCellId, archCopyId))

    		DECLARE @tblChunk TABLE (
    			archCopyId int, streamNum int, volumeId int,
    			archChunkId bigint, commCellId int, copiedBytes bigint, uncopiedBytes bigint)

    		DECLARE @tblVolume TABLE (
    			commCellId int, archCopyId int, streamNum int, volumeId int, volumeName varchar(112),
    			mediaId int, mediaSideId int, CreationTime int, SIDBStoreId int, SiloStatus int,
    			firstChunkId bigint, copiedBytes bigint, uncopiedBytes bigint)

    		DECLARE @tblMedia TABLE (
    			MediaId int, MountPathId int, MountPathName varchar(1024), MountPathTypeId int)

    		DECLARE @tblMediaLocation TABLE (
    			mediaId int, uniqueId varchar(300), barCode varchar(256), mediaTypeId int, attributes int,
    			libraryId int, locationType int, locationId int, location nvarchar(1024))


    		INSERT INTO @tblAFC
    		SELECT	A.id, A.commCellId, B.archGrpCopyId, 0, 0, 0, B.sourceCopyId, 0, 0, 0
    		FROM	archFile A WITH (NOLOCK),
    				(SELECT T.*
    				FROM	JMJobDataStats J WITH (NOLOCK),
    						(SELECT	JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpId, JDS.archGrpCopyId, AGC.sourceCopyId
    						FROM	JMJobDataStats JDS WITH (NOLOCK),
    								(SELECT id AS destCopyId, (case sourceCopyId when 0 then @defCopyId else sourceCopyId end) AS sourceCopyId
    								FROM	archGroupCopy WITH (NOLOCK)
    								WHERE	(@i_copyId <= 0 OR (@i_copyId = @defCopyId AND sourceCopyId = 0) OR id = @i_copyId)
    									AND id <> @defCopyId AND archGroupId = @i_spId AND isActive = 1) AGC
    						WHERE	JDS.archGrpCopyId = AGC.destCopyId AND JDS.status IN (101, 102, 103)
    								AND (JDS.disabled & (1 + 256)) = 0) T
    				WHERE	J.jobId = T.jobId
    					AND J.archGrpCopyId = T.sourceCopyId
    					AND J.dataType = T.dataType
    					AND J.commCellId = T.commCellId
    					AND J.status = 100 AND (J.disabled & (1 + 256)) = 0) B
    		WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
    				AND A.fileType = B.dataType AND A.archGroupId = B.archGrpId AND A.isValid = 1

    		UPDATE	@tblAFC SET srcIsValid= B.isValid, srcStreamNum = B.streamNum, srcPhysicalSize = B.physicalSize
    		FROM	@tblAFC A, archFileCopy B WITH (NOLOCK)
    		WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.sourceCopyId = B.archCopyId

    		UPDATE	@tblAFC SET isValid = B.isValid, streamNum = B.streamNum, physicalSize = B.physicalSize
    		FROM	@tblAFC A, archFileCopy B WITH (NOLOCK)
    		WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.archCopyId = B.archCopyId

    		DELETE	@tblAFC
    		WHERE	isValid = 1 OR srcIsValid <> 1 OR physicalSize = srcPhysicalSize

    		UPDATE	@tblAFC
    		SET		streamNum = (case (B.flags & 4)
    							when 0 then A.srcStreamNum
    							else (1 + (A.srcStreamNum - 1)%B.maxStreamNum) end)
    		FROM	@tblAFC A, archGroupCopy B WITH (NOLOCK)
    		WHERE	A.streamNum = 0 AND A.archCopyId = B.id

    		INSERT INTO @tblChunk
    		SELECT	AFC.archCopyId, AFC.streamNum, 0, ACM.archChunkId, ACM.chunkCommCellId,
    				MAX(AFC.physicalSize - ACM.physicalOffset),
    				SUM(case when (AFC.physicalSize - ACM.physicalOffset) > 0 then (AFC.physicalSize - ACM.physicalOffset) else ACM.physicalSize end)
    		FROM	@tblAFC AFC, archChunkMapping ACM WITH (NOLOCK)
    		WHERE	ACM.archFileId = AFC.archFileId AND ACM.commCellId = AFC.commCellId AND ACM.archCopyId = AFC.sourceCopyId
    				AND ACM.physicalSize > (AFC.physicalSize - ACM.physicalOffset)
    		GROUP BY AFC.archCopyId, AFC.streamNum, ACM.archChunkId, ACM.chunkCommCellId

    		UPDATE	@tblChunk SET volumeId = AC.volumeId
    		FROM	@tblChunk T, archChunk AC WITH (NOLOCK)
    		WHERE	AC.id = T.archChunkId AND AC.commCellId = T.commCellId

    		INSERT INTO @tblVolume
    		SELECT	T.commCellId, T.archCopyId, T.streamNum, V.VolumeId, V.VolumeName,
    				V.MediaId, V.MediaSideId, V.CreationTime, V.SIDBStoreId, V.SiloStatus,
    				T.firstChunkId, T.copiedBytes, T.uncopiedBytes
    		FROM 	(SELECT	commCellId, archCopyId, streamNum, volumeId,
    						MIN(archChunkId) AS firstChunkId, MAX(copiedBytes) AS copiedBytes, SUM(uncopiedBytes) AS uncopiedBytes
    				FROM	@tblChunk
    				GROUP BY commCellId, archCopyId, streamNum, volumeId) T, MMVolume V WITH (NOLOCK)
    		WHERE	T.volumeId = V.VolumeId


    		-- Get media for SILO Restore
    		DECLARE	@SiloVol TABLE (CopyId INT, VolumeId INT, SIDBStoreId INT, CreationTime INT)

    		INSERT	INTO @SiloVol
    		SELECT	0, 0, SIDBStoreId, MAX(CreationTime)
    		FROM	@tblVolume
    		WHERE	SIDBStoreId > 0 AND SiloStatus = 3 /*SILO_VOLUME_MIGRATED_OFFDISK*/
    		GROUP BY SIDBStoreId

    		IF @@ROWCOUNT > 0
    		BEGIN
    			EXEC archMediaForSiloViatable 0, 0

    			INSERT	INTO @tblVolume
    			SELECT	V.origCCcommCellId, S.archGroupCopyId, S.stream, V.VolumeId, V.VolumeName,
    					V.MediaId, V.MediaSideId, V.CreationTime, V.SIDBStoreId, V.SiloStatus,
    					0, 0, 0
    			FROM	@SiloVol T, MMVolume V WITH (READUNCOMMITTED), archStream S WITH (READUNCOMMITTED)
    			WHERE	T.VolumeId = V.VolumeId AND T.VolumeId > 0
    				AND S.mediaGroupId = V.MediaGroupId
    		END

    		INSERT INTO @tblMedia
    		SELECT	a.MediaId, ISNULL(b.MountPathId, 0), ISNULL(b.MountPathName, ''), ISNULL(b.MountPathTypeId, 0)
    		FROM	(SELECT	DISTINCT MediaId, MediaSideId FROM @tblVolume) AS a
    				LEFT OUTER JOIN MMS2getMountPathNameGUIView AS b ON a.MediaSideId = b.MediaSideId

    		INSERT INTO @tblMediaLocation
    		SELECT	DISTINCT M.MediaId, M.UniqueId, M.BarCode, M.MediaTypeId, M.Attributes, M.LibraryId, M.MediaLocation,

    				(case M.MediaTypeId
    				when 10001 then MP.MountPathId
    				else (case M.MediaLocation
    					when 1 then (SELECT SlotId  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
    					when 2 then (SELECT DriveId FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
    					else M.ExportLocationId
    					end)
    				end),

    				(case M.MediaTypeId
    				when 10001 then MP.MountPathName
    				else
    					(case M.MediaLocation
    					when 1 then (SELECT SlotName  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
    					when 2 then (SELECT AliasName FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
    					else ISNULL((SELECT ExportLocation FROM MMExportLocation WHERE ExportLocationId = M.ExportLocationId), '') end)
    				end)

    		FROM	@tblMedia AS MP, MMMedia AS M WITH (NOLOCK)
    		WHERE	M.MediaId = MP.MediaId

    		INSERT INTO @STORAGE_SrcMediaInfoTbl
    		SELECT	@i_spId, (SELECT name FROM archGroup WITH (NOLOCK) WHERE id = @i_spId),
    				M.archCopyId, (SELECT name FROM archGroupCopy WITH (NOLOCK) WHERE id = M.archCopyId), M.streamNum,
    				(case when ML.mediaTypeId = 10001 then M.VolumeName else ML.barCode end),
    				(SELECT AliasName FROM MMLibrary WHERE LibraryId = ML.libraryId), ML.location, M.uncopiedBytes
    		FROM 	@tblVolume M, @tblMediaLocation ML
    		WHERE	M.MediaId = ML.MediaId
    		ORDER BY M.archCopyId, M.streamNum, M.commCellId, M.copiedBytes DESC, M.firstChunkId

    		RETURN
    	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [archUncopiedMediaFn]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'archUncopiedMediaFn' AND revision = '1.2.76.2')

  insert into GXDBVersions values(5, 'archUncopiedMediaFn',  '1.2.76.2', 'archUncopiedMediaFn', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
