

--  ------------  Generated from [../../../Source/CommServer/Db/Function/WeeklyBackupSummary.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: WeeklyBackupSummary'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[WeeklyBackupSummary]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[WeeklyBackupSummary]
  delete from GXDBVersions where name = 'WeeklyBackupSummary' and type = 5
END
GO

 CREATE FUNCTION WeeklyBackupSummary(
	@StartDate		VARCHAR(32),
	@DedupOnly		INTEGER,
	@CountAgedJobs	INTEGER
	)
 RETURNS @Results TABLE (
	StoragePolicy	NVARCHAR(256),
	Copy			NVARCHAR(256),
	Dedupe			VARCHAR(4),
	WeekStartDate	VARCHAR(32),
	AppSizeGB		DECIMAL(20,2),
	SizeOnMediaGB	DECIMAL(20,2),
	DedupeRatio		DECIMAL(20,2),
	Jobs			INT,
	Clients			INT
 )
 AS
 BEGIN

 DECLARE @tblWeek TABLE (WeekStartDate DATETIME, WeekStartTime INT, WeekEndTime INT)

 DECLARE @csTimeZone	VARCHAR(256)
 DECLARE @TmpStartDate	DATETIME
 DECLARE @TmpEndDate	DATETIME
 DECLARE @Today			DATETIME = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), 0)

 SELECT	@csTimeZone = timeZone FROM APP_CommCell WHERE id = 2

 SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
 WHERE	TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)

 SET	@TmpStartDate = dbo.LocalToUTCTime(@StartDate, @csTimeZone)
 SET	@Today = dbo.LocalToUTCTime(@Today, @csTimeZone)

 WHILE (@TmpStartDate < @Today)
 BEGIN
 	SET	@TmpEndDate = DATEADD(DAY, 7, @TmpStartDate)

 	INSERT	INTO @tblWeek
 	SELECT	dbo.UTCToLocalTime(@TmpStartDate, @csTimeZone), dbo.GetUnixTime(@TmpStartDate), dbo.GetUnixTime(@TmpEndDate)

 	SET	@TmpStartDate = @TmpEndDate
 END

 DECLARE @tblSPCopy TABLE (
 		WeekStartDate DATETIME, WeekStartTime INT, WeekEndTime INT,
 		PolicyId INT, PolicyName NVARCHAR(512), CopyId INT, CopyName NVARCHAR(512), dedupeFlags INT)

 INSERT	INTO @tblSPCopy
 SELECT	W.*, C.*
 FROM	@tblWeek W
 		CROSS JOIN (SELECT	AG.id AS PolicyId, AG.name AS PolicyName, AGC.id AS CopyId, AGC.name AS CopyName, AGC.dedupeFlags
 					FROM	archGroup AG INNER JOIN archGroupCopy AGC
 						 ON AGC.archGroupId = AG.id AND AGC.id = AG.defaultCopy
 					WHERE	AG.type = 1 AND AG.id > 1
 						AND ((AGC.dedupeFlags & 262144) > 0 OR @DedupOnly = 0)) C

 DECLARE @tblSummary TABLE (
 		WeekStartDate DATETIME, CopyId INT, AppSize BIGINT, SizeOnMedia BIGINT, nJobs INT, nClients INT)



 INSERT	INTO @tblSummary
 SELECT A.WeekStartDate, A.CopyId,
	 SUM(JM.totalUncompBytes),SUM(A.size),COUNT(DISTINCT A.jobId), COUNT(DISTINCT AA.clientId)
	 from
	 (
	 SELECT	W.WeekStartDate, W.CopyId,
			B.jobId,
 			SUM(D.sizeOnMedia) size
	 FROM	@tblSPCopy W
 			INNER JOIN JMBkpStats B ON B.servStartDate BETWEEN W.WeekStartTime AND W.WeekEndTime
 			INNER JOIN JMJobDataStats D ON D.jobId = B.jobId AND D.commCellId = B.commCellId AND D.archGrpCopyId = W.CopyId
	 WHERE	D.dataType IN (1, 4) AND D.status = 100 AND (@CountAgedJobs = 1 OR (D.disabled & 256) = 0)
  		AND B.status IN (1, 3, 14) and B.opType IN (4, 14, 18, 76) AND B.commCellId = 2
  		AND B.appType < 1000 AND B.appType NOT BETWEEN 600 AND 700
		GROUP BY W.WeekStartDate, W.CopyId,B.jobId
		) A
		INNER JOIN JMBkpStats JM ON A.jobId=JM.jobId
		INNER JOIN APP_Application AA ON AA.id = JM.appId
		GROUP BY A.WeekStartDate, A.CopyId

 INSERT INTO @Results
 SELECT	PolicyName, CopyName, (CASE WHEN (dedupeFlags & 262144) > 0 THEN 'Yes' ELSE 'No' END) AS Dedupe, W.WeekStartDate,
 		ROUND(ISNULL(AppSize/1024/1024/1024, 0), 2) AS AppSizeGB,
 		ROUND(ISNULL(SizeOnMedia/1024/1024/1024, 0), 2) AS SizeOnMediaGB,
 		ISNULL(CASE WHEN (dedupeFlags & 262144) = 0 OR AppSize = 0 OR AppSize < SizeOnMedia THEN 0
 				ELSE ROUND(100.0*(AppSize - SizeOnMedia)/AppSize, 2) END, 0) AS DedupeRatio,
 		ISNULL(nJobs, 0) AS nJobs, ISNULL(nClients, 0) AS nClients
 FROM	@tblSPCopy W
 		LEFT OUTER JOIN @tblSummary S ON S.WeekStartDate = W.WeekStartDate AND S.CopyId = W.CopyId
 ORDER BY PolicyName, CopyName, WeekStartDate DESC

 RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [WeeklyBackupSummary]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'WeeklyBackupSummary' AND revision = '1.3.72.2')

  insert into GXDBVersions values(5, 'WeeklyBackupSummary',  '1.3.72.2', 'WeeklyBackupSummary', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
