

--  ------------  Generated from [../../../Source/CommServer/Db/Function/WR_GetMediaStatusString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: WR_GetMediaStatusString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[WR_GetMediaStatusString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[WR_GetMediaStatusString]
  delete from GXDBVersions where name = 'WR_GetMediaStatusString' and type = 5
END
GO

	CREATE FUNCTION WR_GetMediaStatusString (@localeId INT, @mediaStatusFlag INT)
	RETURNS NVARCHAR(255)
	-- WITH ENCRYPTION
	AS
	BEGIN
	DECLARE	@retStr varchar(255)
	SELECT	@retStr =
			CASE @mediaStatusFlag
				  WHEN 1	THEN N'Active'
				  WHEN 2	THEN N'Appendable'
				  WHEN 4	THEN N'Full'
				  WHEN 8	THEN N'New'
				  WHEN 16	THEN N'Aged'
				  WHEN 32	THEN N'Read Only'
				  WHEN 64	THEN N'Bad'
				  WHEN 128	THEN N'Undiscovered'
				  WHEN 256	THEN N'Duplicate Barcode'
				  WHEN 512	THEN N'Ready'
				  WHEN 1024 THEN N'Offline'
				  WHEN 2048 THEN N'Cleaning'
							ELSE N'N/A'
			END

	IF	@localeId > 0
		SELECT	@retStr = Message
		FROM	WR_LocaleStringsView
		WHERE	LocaleID = @localeId
			AND MessageID = (SELECT TOP 1 MessageID FROM WR_LocaleStringsView WHERE LocaleID = 0 AND Message = @retStr)

	RETURN @retStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [WR_GetMediaStatusString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'WR_GetMediaStatusString' AND revision = '1.2.186.1')

  insert into GXDBVersions values(5, 'WR_GetMediaStatusString',  '1.2.186.1', 'WR_GetMediaStatusString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
