

--  ------------  Generated from [../../../Source/CommServer/Db/Function/WR_GetMediaGroupTypeString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: WR_GetMediaGroupTypeString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[WR_GetMediaGroupTypeString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[WR_GetMediaGroupTypeString]
  delete from GXDBVersions where name = 'WR_GetMediaGroupTypeString' and type = 5
END
GO

	CREATE FUNCTION WR_GetMediaGroupTypeString (@localeId INT, @mediaGroupTypeFlag INT)
	RETURNS NVARCHAR(255)
	-- WITH ENCRYPTION
	AS
	BEGIN
	DECLARE	@retStr varchar(255)
	SELECT	@retStr =
			CASE @mediaGroupTypeFlag
				  WHEN 1	THEN N'Scratch'
				  WHEN 8	THEN N'Retired'
				  WHEN 16	THEN N'Foreign'
				  WHEN 32	THEN N'Cleaning'
				  WHEN 64	THEN N'Overwrite Protected'
				  WHEN 128	THEN N'Catalog'
							ELSE N'N/A'
			END

	IF	@localeId > 0
		SELECT	@retStr = Message
		FROM	WR_LocaleStringsView
		WHERE	LocaleID = @localeId
			AND MessageID = (SELECT TOP 1 MessageID FROM WR_LocaleStringsView WHERE LocaleID = 0 AND Message = @retStr)

	RETURN @retStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [WR_GetMediaGroupTypeString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'WR_GetMediaGroupTypeString' AND revision = '1.1.202.1')

  insert into GXDBVersions values(5, 'WR_GetMediaGroupTypeString',  '1.1.202.1', 'WR_GetMediaGroupTypeString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
