

--  ------------  Generated from [../../../Source/CommServer/Db/Function/VMProtectionCoverage.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: VMProtectionCoverage'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[VMProtectionCoverage]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[VMProtectionCoverage]
  delete from GXDBVersions where name = 'VMProtectionCoverage' and type = 5
END
GO

 CREATE FUNCTION VMProtectionCoverage(
	@nLastDays	INTEGER,
	@BackupType	NVARCHAR(32)
	)
 RETURNS @VMCoverage TABLE (
	VMName				NVARCHAR(256),
	BackupStatus			VARCHAR(256),
	InstanceName			NVARCHAR(256),
	BackupSetName			NVARCHAR(256),
	SubclientName			NVARCHAR(256),
	VMSizeGB			BIGINT,
	VMBackedupSizeGB		BIGINT,
	EstimatedVMDataWrittenSizeGB	BIGINT,
	LastSuccessfulBackupJobId	INTEGER,
	LastBackupTime			DATETIME,
	LastBackupType			NVARCHAR(16),
	TotalTimeForLastBackup		INTEGER,
	clientId					INTEGER,
	CommCellId					INTEGER,
    CommCellName                VARCHAR(256)
 )
 AS
 BEGIN
 -----------------------------------------------------------------------------------
 -- InPut Param: @nLastDays >0, or -1, @BackupType=Full,Synth,Incr
 -- IF @nLastDays = -1 THEN NEEDS TO COUNT ALL CURRENTLY PROTECTED VMS.
 -- USED FOR LICENSING...
 -----------------------------------------------------------------------------------
 		DECLARE	@Today		DATETIME = DATEDIFF(DAY, 0, GETDATE())
 		DECLARE	@StartTime	INT = 0
 		if @nLastDays >=0
 			SET	@StartTime = dbo.GetUnixTime(DATEADD(DAY, -@nLastDays, @Today))
 		DECLARE  @VMInfo TABLE(
			clientId			INT,
 			VMName				nvarchar(1024),
 			VMGuid				nvarchar(255),
			status				INT  --0 Discovered, 1 manually excluded
		)
 		DECLARE @tblBackupLevel TABLE (BackupLevel INT)
 		IF @BackupType = 'Full'
 		BEGIN
			INSERT INTO @tblBackupLevel VALUES(1)
			INSERT INTO @tblBackupLevel VALUES(1024)
			INSERT INTO @tblBackupLevel VALUES(32768)
 		END
 		ELSE IF @BackupType LIKE '%Synth%'
 		BEGIN
			INSERT INTO @tblBackupLevel VALUES(64)
			INSERT INTO @tblBackupLevel VALUES(16384)
 		END
 		ELSE IF @BackupType LIKE '%Incr%'
 		BEGIN
			INSERT INTO @tblBackupLevel VALUES(2)
			INSERT INTO @tblBackupLevel VALUES(4)
			INSERT INTO @tblBackupLevel VALUES(128)
			INSERT INTO @tblBackupLevel VALUES(256)
 		END
 		ELSE
			SET @BackupType = ''
			INSERT INTO @VMInfo  (clientId, VMName, VMGuid,status)
			select distinct C.id, C.name, '', 0 from APP_Client C WITH (NOLOCK)
			INNER JOIN APP_ClientProp CP WITH (NOLOCK)
			ON C.id = CP.componentNameId
			AND CP.attrName = 'Virtual Server Discovered Clients'
			AND CP.modified =0
			AND CP.attrVal = '1'
			UPDATE @VMInfo
			SET VMGuid = CP.attrVal FROM APP_ClientProp CP WITH (NOLOCK) INNER JOIN @VMInfo vmInfo ON
			vmInfo.clientId = CP.componentNameId
			AND CP.attrName='Virtual Machine GUID'
			DECLARE @VMJobInfo TABLE(
				commcellid					INT,
				clientId					INT,
				appId						INT,
				BackupStatus			    INT, -- 0 - Backed Up, 1 -  Did Not Backup, 2 - manually exlcuded
				LastSuccessfulBackupJobId	BIGINT,
				LastBackupJobId				BIGINT,
				LastBackupType				INT,
				LastBackupTime				BIGINT,
				VMBackupStartTime			BIGINT,
				VMBackupEndTime				BIGINT,
				TotalTimeForLastBackup		BIGINT,
				BackupSetName				nvarchar(1024),
				InstanceName				nvarchar(1024),
				SubClientName				nvarchar(1024),
				VMSize						BIGINT,
				VMDataWrittenSize			BIGINT,
				VMBackedupSize				BIGINT,
				DataStatus				INT
			)
			DECLARE @VMTotalSize TABLE(
				vmJobId				INT,
				TotalVMBackupSize	BIGINT,
				DataWritten			BIGINT
			)
			INSERT	INTO @VMJobInfo
			SELECT	JMQ.commCellId,
					JMQ.clientId,
					MAX(B.appId),
					1,
					MAX(CASE  WHEN B.status in ( 1,3,14,16)  THEN(
								CASE	WHEN V.attrVal IS NOT NULL AND V.attrVal IN ('0', '3')
									THEN B.jobid
								WHEN V.attrVal IS  NULL AND JMQ.status IN (1,3)
									THEN B.jobId
								ELSE 0
								END)
						END),
					MAX(B.jobId),
					0,
					0,
					0,
					0,
					0,
					NULL,
					NULL,
					NULL,
					0,
					0,
					0,
					0
			FROM JMQinetixUpdateStatus JMQ WITH (NOLOCK)
				INNER JOIN JMBkpStats B WITH (NOLOCK) ON
					B.jobId = JMQ.jobId AND
					B.commCellId = B.commCellId AND
					(@BackupType = '' OR B.bkpLevel IN (SELECT BackupLevel FROM @tblBackupLevel))
				LEFT OUTER JOIN APP_VMProp V WITH (NOLOCK) ON
					JMQ.jobId = V.jobId AND
					JMQ.commCellId = V.commCellId AND
					JMQ.clientId = V.VMclientId AND
				V.attrName = 'vmStatus'
			WHERE	B.appType = 106
			GROUP BY
				JMQ.clientId, JMQ.commCellId
		UPDATE @VMJobInfo
		SET VMSize = CAST(V.attrVal as bigint)
		FROM APP_VMProp V WITH (NOLOCK) INNER JOIN @VMJobInfo vm ON
			V.VMclientId = vm.clientId
			AND vm.LastSuccessfulBackupJobId = V.jobId
			AND V.attrName ='vmSize'
		UPDATE @VMJobInfo
		SET VMBackedupSize = CAST(V.attrVal as bigint)
		FROM APP_VMProp V WITH (NOLOCK) INNER JOIN @VMJobInfo vm ON
			V.VMclientId = vm.clientId
			AND vm.LastSuccessfulBackupJobId = V.jobId
			AND V.attrName ='vmUsedSpace'
		UPDATE @VMJobInfo
		SET VMBackupStartTime = CAST(V.attrVal AS BIGINT)
		FROM APP_VMProp V WITH (NOLOCK) INNER JOIN @VMJobInfo vm ON
			V.VMclientId = vm.clientId
			AND vm.LastSuccessfulBackupJobId = V.jobId
			AND V.attrName ='vmBackupStartTime'
		UPDATE @VMJobInfo
		SET VMBackupEndTime = CAST(V.attrVal AS BIGINT)
		FROM APP_VMProp V WITH (NOLOCK) INNER JOIN @VMJobInfo vm ON
			V.VMclientId = vm.clientId
			AND vm.LastSuccessfulBackupJobId = V.jobId
			AND V.attrName ='vmBackupEndTime'
		INSERT INTO @VMTotalSize
		SELECT LastSuccessfulBackupJobId, SUM(VMBackedupSize),0 FROM @VMJobInfo where LastSuccessfulBackupJobId > 0 group by LastSuccessfulBackupJobId
		UPDATE  @VMTotalSize
		SET     DataWritten = ISNULL(
					   (SELECT TOP 1 T.sizeOnMedia
						   FROM    (SELECT S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
							   FROM    JMJobDataStats S WITH (READUNCOMMITTED)
								   WHERE   2 = S.commcellId and vmJobId =S.jobid and S.AuxCopyJobId = 0
								   GROUP BY S.archGrpCopyId) AS T),0)
		UPDATE	@VMJobInfo
		SET		appId = B.appId,
				LastBackupType = B.bkpLevel,
				--TotalTimeForLastBackup = (B.servEndDate - B.servStartDate),
					LastBackupTime = B.servEndDate,
					DataStatus = B.DataStatus
			FROM	@VMJobInfo V INNER JOIN
					JMBkpStats B WITH (NOLOCK) ON
					B.jobId =  V.LastSuccessfulBackupJobId
					AND B.commCellId = V.commcellid
					AND B.status in (1,3,14,16)
		IF @nLastDays < 0
			DELETE FROM @VMJobInfo WHERE DataStatus >0
		UPDATE @VMJobInfo
		SET		appId = B.appId
		FROM @VMJobInfo V INNER JOIN
			JMBkpStats B WITH (NOLOCK) ON
			v.LastSuccessfulBackupJobId = 0
			AND B.jobId = v.LastBackupJobId
		UPDATE	@VMJobInfo
		SET		SubClientName = A.subclientName,
				BackupSetName = BS.name,
				InstanceName = I.name
		FROM	@VMJobInfo vmJobInfo
				INNER JOIN APP_Application A WITH (NOLOCK) ON
					vmJobInfo.appId = A.id
					INNER JOIN APP_BackupSetName BS WITH (NOLOCK) ON
					BS.id = A.backupSet
				INNER JOIN APP_InstanceName I ON
					I.id = A.instance
		if @nLastDays >=0
			UPDATE @VMJobInfo
			SET BackupStatus = ( SELECT CASE WHEN LastBackupTime < @StartTime THEN 1
										 ELSE 0
										 END )
		else
			UPDATE @VMJobInfo SET BackupStatus = 0 where LastBackupTime >0
		UPDATE @VMInfo SET status = 1
		FROM @VMInfo vmInfo
			INNER JOIN APP_SubClientProp SCP WITH (NOLOCK)
				ON	vmInfo.VMName = SUBSTRING(SCP.attrVal, 0, CHARINDEX(' ',SCP.attrVal))
				AND	SCP.attrType = 121 AND SCP.modified = 0
			INNER JOIN APP_Application app WITH (NOLOCK)
				ON app.id = SCP.componentNameId
			AND	app.subclientName LIKE 'Do Not Backup' AND app.appTypeId = 106
		UPDATE @VMJobInfo
		SET VMDataWrittenSize = cast(VMBackedupSize*(cast(vmTotalSize.DataWritten as real)/vmTotalSize.TotalVMBackupSize) as bigint)
		FROM @VMTotalSize vmTotalSize INNER JOIN @VMJobInfo
		ON vmTotalSize.vmJobId = LastSuccessfulBackupJobId
		AND vmTotalSize.TotalVMBackupSize > 0
		AND LastSuccessfulBackupJobId >0
	DECLARE @CommCellId INT
	DECLARE @aliasName varchar(256)
	SELECT @CommCellId = number, @aliasName=aliasName from APP_CommCell WITH (NOLOCK) where clientId =2
		INSERT INTO @VMCoverage
			SELECT	VMName,
					(CASE WHEN BackupStatus IS NULL
						THEN ( CASE vmInfo.status  WHEN 0 THEN 'Discovered, Not protected'
								ELSE 'Manually Excluded'
								END
						)
						ELSE ( CASE BackupStatus
								WHEN 0 THEN 'Currently protected'
								WHEN 1 THEN 'Not protected in the time range'
								END
						)
						END ) as BackupStatus,
					InstanceName,
					BackupSetName,
					SubClientName,
					CAST(VMSize/1024.0/1024.0/1024.0 as decimal(10,2)) as VMSizeGB,
					CAST(VMBackedupSize/1024.0/1024/1024 as decimal(10,2)) as VMBackedupSizeGB,
					CAST(VMDataWrittenSize/1024.0/1024/1024 as decimal(10,2) ) as EstimatedVMDataWrittenSizeGB,
					LastSuccessfulBackupJobId,
					dbo.GetDateTime(LastBackupTime) as LastBackupTime,
					CASE LastBackupType
						WHEN 1 THEN 'Full'
						WHEN 2 THEN 'Incremental'
						WHEN 4 THEN 'Differential'
						WHEN 64 THEN 'SyntheticFull'
						ELSE null
						END as LastBackupType,
					--TotalTimeForLastBackup,
					VMBackupEndTime - VMBackupStartTime as TotalTimeForLastBackup,
					vmInfo.clientId,
					@CommCellId as CommCellId,
                    @aliasName  as CommCellName
			FROM	@VMInfo vmInfo
			LEFT OUTER JOIN @VMJobInfo vmJobInfo
			ON vmInfo.clientId = vmJobInfo.clientId
			ORDER BY VMName
    RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [VMProtectionCoverage]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'VMProtectionCoverage' AND revision = '1.7.60.1')

  insert into GXDBVersions values(5, 'VMProtectionCoverage',  '1.7.60.1', 'VMProtectionCoverage', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
