

--  ------------  Generated from [../../../Source/CommServer/Db/Function/UTCToCellLocalTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: UTCToCellLocalTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UTCToCellLocalTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[UTCToCellLocalTime]
  delete from GXDBVersions where name = 'UTCToCellLocalTime' and type = 5
END
GO

	CREATE FUNCTION UTCToCellLocalTime(@UTCTime DATETIME, @commCellId INT)
	RETURNS DATETIME
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @commCellTimeZoneName nvarchar(255) = ( SELECT  timeZone
		                                                FROM    APP_CommCell
		                                                WHERE   id = @commCellId)
		SELECT  @commCellTimeZoneName = TimeZoneStdName
		FROM    SchedTimeZone
		WHERE   TimeZoneName = SUBSTRING(@commCellTimeZoneName, CHARINDEX(':', @commCellTimeZoneName, CHARINDEX(':', @commCellTimeZoneName, 0) + 1) + 1, 255)
		RETURN dbo.UTCToLocalDateTimeConversionManaged(@UTCTime, @commCellTimeZoneName)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [UTCToCellLocalTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'UTCToCellLocalTime' AND revision = '1.2.212.1')

  insert into GXDBVersions values(5, 'UTCToCellLocalTime',  '1.2.212.1', 'UTCToCellLocalTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
