

--  ------------  Generated from [../../../Source/CommServer/Db/Function/TOGet_working_days.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: TOGet_working_days'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[TOGet_working_days]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[TOGet_working_days]
  delete from GXDBVersions where name = 'TOGet_working_days' and type = 5
END
GO

		CREATE FUNCTION [dbo].[TOGet_working_days]
		(
			@StartDate DATETIME,
			@EndDate DATETIME
		)
		RETURNS INT
		AS
		BEGIN
			DECLARE @TotalDays INT = ((DATEDIFF(DAY, @StartDate, @EndDate) + 1) / 7) * 5
			DECLARE @TempDate DATETIME
			DECLARE @i INT = 0
			WHILE (@i < ((DATEDIFF(DAY, @StartDate, @EndDate) + 1) % 7))
			BEGIN
				SET @TempDate = DATEADD(DAY, @i, @StartDate)
				SET @i = @i + 1
				IF( DATEPART(WEEKDAY, @TempDate) <> 1 AND DATEPART(WEEKDAY,@TempDate) <> 7)
				BEGIN
					SET @TotalDays = @TotalDays + 1
				END
			END
			SET @TotalDays = @TotalDays
			RETURN @TotalDays
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [TOGet_working_days]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'TOGet_working_days' AND revision = '')

  insert into GXDBVersions values(5, 'TOGet_working_days',  '', 'TOGet_working_days', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
