

--  ------------  Generated from [../../../Source/CommServer/Db/Function/TOGet_total_working_days.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: TOGet_total_working_days'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[TOGet_total_working_days]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[TOGet_total_working_days]
  delete from GXDBVersions where name = 'TOGet_total_working_days' and type = 5
END
GO

		CREATE  FUNCTION [dbo].[TOGet_total_working_days]
		(
			-- Add the parameters for the function here
			@StartDate DATETIME,
			@EndDate DATETIME,
			@nOptHolidaysAvailed INT,
			@nLocationID INT
		)
		RETURNS INT
		AS
		BEGIN
			DECLARE @TotalDays INT = ((DATEDIFF(DAY, @StartDate, @EndDate) + 1) / 7) * 5
			DECLARE @TempDate DATETIME
			DECLARE @i INT = 0
			DECLARE @Holiday_Count INT = 0
			WHILE (@i < ((DATEDIFF(DAY, @StartDate, @EndDate) + 1) % 7))
			BEGIN
				SET @TempDate = DATEADD(DAY, @i, @StartDate)
				SET @i = @i + 1
				IF( DATEPART(WEEKDAY, @TempDate) <> 1 AND DATEPART(WEEKDAY,@TempDate) <> 7)
				BEGIN
					SET @TotalDays = @TotalDays + 1
				END
			END
			IF (NOT(@nOptHolidaysAvailed > 0)) OR (@nOptHolidaysAvailed IS NULL)
				SET @nOptHolidaysAvailed = 0
			DECLARE @nParentLocID INT  = 0
			SELECT @nParentLocID = nParentLocID FROM TOLocation WHERE nID = @nLocationID
			SELECT @Holiday_Count = SUM(CASE WHEN dStartDate <> dEndDate
										 AND (dStartDate >= @StartDate  AND dEndDate <= @EndDate)THEN dbo.TOGet_working_days(dStartDate, dEndDate)
										 WHEN (dStartDate < @StartDate AND dEndDate BETWEEN @StartDate AND @EndDate)THEN dbo.TOGet_working_days(@StartDate, dEndDate)
										 WHEN (dEndDate > @EndDate AND dStartDate BETWEEN @StartDate AND @EndDate)THEN dbo.TOGet_working_days(dStartDate, @EndDate)
										 WHEN (dStartDate < @StartDate AND dEndDate > @EndDate)THEN dbo.TOGet_working_days(@StartDate, @EndDate)
										 ELSE 1 END)
				FROM TOHolidays WHERE (nLocationID = @nLocationID OR nLocationID = @nParentLocID) AND ((dStartDate BETWEEN @StartDate AND @EndDate) OR (dEndDate BETWEEN @StartDate AND @EndDate)) AND nIsOptional = 0
			IF @Holiday_Count <> 0
				SET @TotalDays = @TotalDays - @Holiday_Count - @nOptHolidaysAvailed
			ELSE
				SET @TotalDays = @TotalDays - @nOptHolidaysAvailed
			RETURN @TotalDays
		END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [TOGet_total_working_days]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'TOGet_total_working_days' AND revision = '')

  insert into GXDBVersions values(5, 'TOGet_total_working_days',  '', 'TOGet_total_working_days', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
