

--  ------------  Generated from [../../../Source/CommServer/Db/Function/TM_GetNextRunTimeScForContSchedule.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: TM_GetNextRunTimeScForContSchedule'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[TM_GetNextRunTimeScForContSchedule]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[TM_GetNextRunTimeScForContSchedule]
  delete from GXDBVersions where name = 'TM_GetNextRunTimeScForContSchedule' and type = 5
END
GO

CREATE FUNCTION TM_GetNextRunTimeScForContSchedule(@jobStartTime INTEGER, @rpoFreq INTEGER, @clientTimezone NVARCHAR(1024) )
RETURNS INTEGER
AS
BEGIN
	IF @rpoFreq = 0
	BEGIN
		-- Max int value so that job doesnt run at all.
		RETURN 2147483647
	END
	-- Suppose job start time is 5AM, first get Unix time for Previous day 5AM
	-- First get the unix time for 5 AM on given timezone.
	DECLARE @currentLocalTime DATETIME = dbo.UTCToLocalDateTimeConversionManaged(GETUTCDATE(), @clientTimezone)
	DECLARE @localDateJobStartTime DATETIME = DateAdd(ss,@jobStartTime,Convert(DateTime, DATEDIFF(DAY, 0, @currentLocalTime  ) - 1))
	-- If current time now is 6AM then take day of today 5 AM
	IF (DATEDIFF(ss, @localDateJobStartTime,@currentLocalTime )>(3600*24) )
	BEGIN
		SET @localDateJobStartTime = DATEADD(Day,1,@localDateJobStartTime)
	END
	DECLARE @jobStartTimeUnix INT = dbo.getunixTime(@localDateJobStartTime)
	SET @jobStartTimeUnix = dbo.getunixtime(@currentLocalTime) + (@rpoFreq*60) - ( (dbo.getunixtime(@currentLocalTime)-@jobStartTimeUnix)%(@rpoFreq*60) )
	-- If the job start time exceeds next day job start time(next day 5 AM) then set it to that time.
	-- Suppose last job time is 1AM and job start time, set job start time to 5AM instead of 6 AM.
	IF (@jobStartTimeUnix>dbo.getunixtime(DATEADD(Day,1,@localDateJobStartTime)))
	BEGIN
		RETURN dbo.getunixtime(dbo.LocalToUTCDateTimeConversionManaged((DATEADD(Day,1,@localDateJobStartTime)),@clientTimezone))
	END
	RETURN dbo.getunixtime(dbo.LocalToUTCDateTimeConversionManaged(DATEADD(second,@jobStartTimeUnix, CAST('1970-01-01 00:00:00' AS datetime)) ,@clientTimezone))
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [TM_GetNextRunTimeScForContSchedule]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'TM_GetNextRunTimeScForContSchedule' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'TM_GetNextRunTimeScForContSchedule',  '1.1.2.2', 'TM_GetNextRunTimeScForContSchedule', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
