

--  ------------  Generated from [../../../Source/CommServer/Db/Function/StrikeRecovery.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: StrikeRecovery'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[StrikeRecovery]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[StrikeRecovery]
  delete from GXDBVersions where name = 'StrikeRecovery' and type = 5
END
GO

 CREATE FUNCTION StrikeRecovery (
	@BackupWindowFrom	VARCHAR(32),
	@CountSynthFull		INTEGER,
	@NumberOfDays		INTEGER
	)
 RETURNS @Results TABLE (
 	StrikeCounts	INT,
	CommServer		NVARCHAR(256),
	ClientGroups	NVARCHAR(1024),
	Client			NVARCHAR(256),
 	Agent			NVARCHAR(256),
 	Instance		NVARCHAR(256),
 	Backupset		NVARCHAR(256),
 	Subclient		NVARCHAR(256),
 	BackupType		NVARCHAR(32),
 	FailedFrom		NVARCHAR(32),
 	FailedDays		INT,
 	RecoveryJobID	INT,
 	RecoveryJobStart NVARCHAR(32),
 	RecoveryJobEnd	NVARCHAR(32),
	TimeZone		NVARCHAR(256)
 )
 AS
 BEGIN

 DECLARE @csName	VARCHAR(256)
 DECLARE @csTimeZone VARCHAR(256)

 SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2

 SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
 WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)

 DECLARE @dtCurrWindowBegin	DATETIME = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), @BackupWindowFrom)
 SET	 @dtCurrWindowBegin	= dbo.ClientLocalToUTCTime(@dtCurrWindowBegin, 2)
 DECLARE @hms INT = DATEPART(HOUR, @dtCurrWindowBegin)*3600 +  DATEPART(MINUTE, @dtCurrWindowBegin)*60 + DATEPART(SECOND, @dtCurrWindowBegin)
 DECLARE @CurrWindowEnd		INT = dbo.GetUnixTime(DATEADD(DAY, 1, @dtCurrWindowBegin))
 DECLARE @PrevWindowBegin	INT = dbo.GetUnixTime(DATEADD(DAY, -@NumberOfDays, @dtCurrWindowBegin))

 DECLARE @TblFailedApp TABLE (vmClientId INT, appId INT, backupType INT, prevSuccJobTime INT, recoveryJobTime INT, recoveryJobStart DATETIME,
							firstFailedJobStart DATETIME, lastFailedJobId INT, lastFailedJobTime INT)

 INSERT INTO @TblFailedApp
 SELECT	0, appId, CASE WHEN bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END, 0, 0, NULL, NULL, MAX(jobId), 0
 FROM	JMBkpStats
 WHERE	(bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND status NOT IN (1, 14) AND failureErrorCode <> 8
 	AND (status <> 3 OR appType NOT IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND opType IN (4, 14, 76) AND commCellId = 2
 	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700 AND appType <> 106
 GROUP BY appId, CASE WHEN bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END

 DELETE	@TblFailedApp
 FROM	@TblFailedApp F INNER JOIN APP_Application A ON F.appId = A.id
 WHERE	dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 0
	OR A.id IN (SELECT componentNameId FROM APP_subclientProp WHERE attrName = 'DDB Backup' AND attrVal <> '0' AND modified = 0)
	OR A.clientId IN (SELECT componentNameId FROM APP_ClientProp WHERE attrName = 'Content Index Server' AND attrVal = '1')
	OR EXISTS (SELECT * FROM JMJobAction WHERE opType = 4 AND action = 1 AND (clientId = A.ClientId AND appType IN (A.AppTypeId, 0) OR appId = A.id))

 INSERT INTO @TblFailedApp
 SELECT JMQ.clientId, J.appId, CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END, 0, 0, NULL, NULL, MAX(J.jobId), 0
	FROM	JMQinetixUpdateStatus JMQ
		INNER JOIN JMBkpStats J
 		ON J.jobId = JMQ.jobId AND J.commCellId = JMQ.commCellId
		INNER JOIN APP_VMProp V
 		ON JMQ.jobId = V.jobId AND JMQ.commCellId = V.commCellId
 			AND JMQ.clientId = V.VMclientId AND V.attrName = 'vmStatus' AND V.attrVal IN ('1', '2', '4')
 WHERE	J.appType = 106 and J.commCellId = 2 and JMQ.commCellId = 2
 	AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND J.status NOT IN (1, 14) AND J.failureErrorCode <> 8
 	AND opType IN (4, 14, 76)
 	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700
 GROUP BY JMQ.clientId, J.appId, CASE WHEN bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END

 UPDATE @TblFailedApp
 SET	lastFailedJobTime = J.servStartDate
 FROM	@TblFailedApp F INNER JOIN JMBkpStats J ON J.jobId = F.lastFailedJobId AND J.commCellId = 2

 DECLARE @TblLastSuccJob TABLE (vmClientId INT, appId INT, backupType INT, jobId INT, startTime INT, backupLevel INT)

 INSERT INTO @TblLastSuccJob
 SELECT	0, F.appId, F.backupType, MIN(J.jobId), 0, 0
 FROM	JMBkpStats J INNER JOIN @TblFailedApp F
	ON  J.appId = F.appId AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
 WHERE	(J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND (J.status IN (1, 14) OR J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND J.opType IN (4, 14, 76) AND J.commCellId = 2
 	AND J.servStartDate > F.lastFailedJobTime
 GROUP BY F.appId, F.backupType

 INSERT INTO @TblLastSuccJob
 SELECT F.vmClientId, J.appId, F.backupType, MIN(J.jobId), 0, 0
 FROM	JMQinetixUpdateStatus JMQ
 	INNER JOIN @TblFailedApp F
 		ON F.vmClientId = JMQ.clientId AND F.vmClientId > 0
 	INNER JOIN JMBkpStats J
 		ON J.jobId = JMQ.jobId AND J.commCellId = JMQ.commCellId
 		AND F.appId = J.appId
 		AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
 	INNER JOIN APP_VMProp V
 		ON JMQ.jobId = V.jobId AND JMQ.commCellId = V.commCellId AND JMQ.clientId = V.VMclientId
 		AND V.attrName = 'vmStatus' AND V.attrVal IN ('0', '3')
 WHERE	J.appType = 106 and J.commCellId = 2 and JMQ.commCellId = 2
 	AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 AND (J.status IN (1, 3, 14)) --OR J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 AND opType IN (4, 14, 76)
 AND J.servStartDate > F.lastFailedJobTime
 GROUP BY F.vmClientId, J.appId, F.backupType

 UPDATE @TblLastSuccJob
 SET		startTime = J.servStartDate, backupLevel = J.bkpLevel
 FROM	@TblLastSuccJob S INNER JOIN JMBkpStats J ON J.jobId = S.jobId AND J.commCellId = 2

 --DELETE @TblFailedApp
 --FROM	@TblFailedApp F INNER JOIN @TblLastSuccJob S ON F.vmClientId = S.vmClientId AND F.appId = S.appId
 --WHERE	F.lastFailedJobTime <= S.startTime AND S.backupType IN (1, F.backupType)

 UPDATE @TblFailedApp
 SET	recoveryJobTime = S.startTime, recoveryJobStart = dbo.getDateTime(S.startTime)
 FROM	@TblFailedApp F INNER JOIN @TblLastSuccJob S ON F.vmClientId = S.vmClientId AND F.appId = S.appId AND F.backupType = S.backupType

 UPDATE @TblFailedApp
 SET	recoveryJobTime = FF.startTime, recoveryJobStart = dbo.getDateTime(FF.startTime)
 FROM	@TblFailedApp F INNER JOIN @TblLastSuccJob FF ON F.vmClientId = FF.vmClientId AND F.appId = FF.appId
 WHERE	F.backupType = 2 AND FF.backupType = 1 AND F.recoveryJobTime > FF.startTime
 	AND (@CountSynthFull = 0 OR FF.backupLevel NOT IN (64, 128, 16384))

 DELETE @TblFailedApp
 WHERE	recoveryJobTime < lastFailedJobTime OR recoveryJobTime < @PrevWindowBegin

 DECLARE @TblPrevSuccJob TABLE (vmClientId INT, appId INT, backupType INT, startTime INT)

 INSERT INTO @TblPrevSuccJob
 SELECT	0, F.appId, F.backupType, MAX(J.servStartDate)
 FROM	JMBkpStats J INNER JOIN @TblFailedApp F
	ON  J.appId = F.appId AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
 WHERE	(J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND (J.status IN (1, 14) OR J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND J.opType IN (4, 14, 76) AND J.commCellId = 2
  	AND J.servStartDate < F.lastFailedJobTime
 GROUP BY F.appId, F.backupType

 INSERT INTO @TblPrevSuccJob
 SELECT F.vmClientId, J.appId, F.backupType, MAX(J.servStartDate)
 FROM	JMQinetixUpdateStatus JMQ
	INNER JOIN @TblFailedApp F
		ON F.vmClientId = JMQ.clientId AND F.vmClientId > 0
	INNER JOIN JMBkpStats J
		ON J.jobId = JMQ.jobId AND J.commCellId = JMQ.commCellId
		AND F.appId = J.appId
		AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
	INNER JOIN APP_VMProp V
		ON JMQ.jobId = V.jobId AND JMQ.commCellId = V.commCellId AND JMQ.clientId = V.VMclientId
		AND V.attrName = 'vmStatus' AND V.attrVal IN ('0', '3')
 WHERE	J.appType = 106 and J.commCellId = 2 and JMQ.commCellId = 2
	AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
	AND (J.status IN (1, 3, 14)) --OR J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
	AND opType IN (4, 14, 76)
 GROUP BY F.vmClientId, J.appId, F.backupType

 UPDATE @TblFailedApp
 SET	prevSuccJobTime = S.startTime
 FROM	@TblFailedApp F INNER JOIN @TblPrevSuccJob S ON F.appId = S.appId AND F.backupType = S.backupType

 UPDATE @TblFailedApp
 SET	prevSuccJobTime = FF.startTime
 FROM	@TblFailedApp F INNER JOIN @TblPrevSuccJob FF ON F.appId = FF.appId
 WHERE	F.backupType = 2 AND FF.backupType = 1 AND FF.startTime BETWEEN F.prevSuccJobTime AND F.lastFailedJobTime
 	AND (@CountSynthFull = 0 OR NOT EXISTS(SELECT jobId FROM JMBkpStats
 		WHERE appId = FF.appId AND servStartDate = FF.startTime AND bkpLevel IN (64, 128, 16384)))

 DECLARE @TblFirstFailedJob TABLE (vmClientId INT, appId INT, backupType INT, startTime INT)

 INSERT INTO @TblFirstFailedJob
 SELECT	0, F.appId, F.backupType, MIN(J.servStartDate)
 FROM	JMBkpStats J INNER JOIN @TblFailedApp F
	ON  J.appId = F.appId AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
 WHERE	(J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND J.status NOT IN (1, 14) AND J.failureErrorCode <> 8
 	AND (J.status <> 3 OR J.appType NOT IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND J.opType IN (4, 14, 76) AND J.commCellId = 2
 	AND J.servStartDate BETWEEN F.prevSuccJobTime AND F.lastFailedJobTime
 GROUP BY F.appId, F.backupType

 INSERT INTO @TblFirstFailedJob
 SELECT	F.vmClientId, J.appId, F.backupType, MIN(J.servStartDate)
 	FROM	JMBkpStats J
 	INNER JOIN @TblFailedApp F
 		ON J.appId = F.appId AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
 	INNER JOIN APP_VMProp V
 		ON V.jobId = J.jobId AND V.commCellId = J.commCellId
 		AND V.attrName = 'vmStatus' AND V.attrVal IN ('1', '2', '4')
 		AND J.appType = 106 AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 		AND J.status NOT IN (1, 14) AND J.failureErrorCode <> 8
 		AND J.opType IN (4, 14, 76) AND J.commCellId = 2
 		AND J.servStartDate BETWEEN F.prevSuccJobTime AND F.lastFailedJobTime
 GROUP BY F.vmClientId, J.appId, F.backupType

 UPDATE @TblFailedApp
 SET	firstFailedJobStart = dbo.GetDateTime(FF.startTime)
 FROM	@TblFailedApp F INNER JOIN @TblFirstFailedJob FF ON F.vmClientId = FF.vmClientId AND F.appId = FF.appId AND F.backupType = FF.backupType

 DECLARE @TblStrikes TABLE (
 		vmClientId INT, appId INT, backupType INT, failedFrom DATETIME, failedDays INT, hourDiff1 INT, hourDiff2 INT,
 		recoveryJobId INT, recoveryJobStart DATETIME, recoveryJobEnd DATETIME)

 INSERT INTO @TblStrikes
 SELECT	F.vmClientId, F.appId, F.backupType, F.firstFailedJobStart,
 		DATEDIFF(DAY, F.firstFailedJobStart, F.recoveryJobStart),
 		CASE WHEN ( DATEPART(HOUR,   F.firstFailedJobStart)*3600 +
 					DATEPART(MINUTE, F.firstFailedJobStart)*60 +
 					DATEPART(SECOND, F.firstFailedJobStart) ) < @hms
 		THEN -1 ELSE 1 END,
 		CASE WHEN ( DATEPART(HOUR,   F.recoveryJobStart)*3600 +
 					DATEPART(MINUTE, F.recoveryJobStart)*60 +
 					DATEPART(SECOND, F.recoveryJobStart) ) < @hms
 		THEN -1 ELSE 1 END,
 		J.jobId, dbo.GetDateTime(J.servStartDate), dbo.GetDateTime(J.servEndDate)
 FROM	JMBkpStats J INNER JOIN @TblFailedApp F
	ON  J.jobId = F.lastFailedJobId AND J.commCellId = 2;

 UPDATE	@TblStrikes
 SET	failedDays = ISNULL(failedDays + (CASE WHEN hourDiff1 < 0 AND hourDiff2 > 0 THEN 1 WHEN hourDiff1 > 0 AND hourDiff2 < 0 THEN -1 ELSE 0 END), 0)

 INSERT INTO @Results
 SELECT	CASE WHEN F.failedDays = 0 THEN 1 WHEN F.failedDays > 3 THEN 3 ELSE F.failedDays END AS StrikeCounts,
 		@csName AS CommServer,
 		ISNULL(CG.ClientGroups, '') AS ClientGroups,
 		CASE WHEN F.vmClientId = 0 THEN CL.name ELSE (SELECT name FROM APP_Client WHERE id = F.vmClientId) END AS Client,
 		IDA.name AS Agent,
 		dbo.FixInstanceName(INS.name, A.appTypeId) AS Instance,
 		B.name AS Backupset,
 		A.subclientName AS Subclient,
 		CASE WHEN F.backupType = 1 THEN 'Full' ELSE 'NonFull' END AS BackupType,
 		dbo.UTCToLocalStringTime(F.failedFrom, @csTimeZone) AS FailedFrom,
 		F.failedDays AS FailedDays,
 		F.recoveryJobId AS RecoveryJobID,
 		dbo.UTCToLocalStringTime(F.recoveryJobStart, @csTimeZone) AS RecoveryJobStart,
 		dbo.UTCToLocalStringTime(F.recoveryJobEnd,   @csTimeZone) AS RecoveryJobEnd,
 		@csTimeZone AS TimeZone
 FROM	@TblStrikes F
 		INNER JOIN APP_Application A ON A.id = F.appId
 		LEFT OUTER JOIN ClientGroupsStringView CG ON A.clientId = CG.ClientId
 		INNER JOIN APP_Client CL ON CL.id = A.clientId
 		INNER JOIN APP_iDAType IDA ON IDA.type = A.appTypeId
 		INNER JOIN APP_InstanceName INS ON INS.id = A.instance
 		INNER JOIN APP_BackupSetName B ON B.id = A.backupSet
 ORDER BY StrikeCounts, ClientGroups, Client, Agent, Instance, Backupset, Subclient, BackupType

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [StrikeRecovery]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'StrikeRecovery' AND revision = '1.3')

  insert into GXDBVersions values(5, 'StrikeRecovery',  '1.3', 'StrikeRecovery', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
