

--  ------------  Generated from [../../../Source/CommServer/Db/Function/Stat_GetTCriticalValue.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: Stat_GetTCriticalValue'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[Stat_GetTCriticalValue]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[Stat_GetTCriticalValue]
  delete from GXDBVersions where name = 'Stat_GetTCriticalValue' and type = 5
END
GO

  --@inputProb -probability value
  CREATE FUNCTION dbo.Stat_GetTCriticalValue(@degreesOfFreedom int,@inputProb float)
  RETURNS float
  AS
  BEGIN
	DECLARE @colName varchar(3)
	DECLARE @sqlstring nvarchar(500)
	DECLARE @crit float
	DECLARE @CriticalValueRange TABLE(probability float)
	INSERT INTO @CriticalValueRange (probability) VALUES(.95),(.975),(.99),(.995),(.999),(.9995)
	DECLARE @sig float=0
	--get nearest probability level
	SET @sig=(SELECT TOP(1) probability FROM @CriticalValueRange ORDER BY ABS(@inputProb-probability))
	SET @crit=(SELECT TOP(1)
			CASE @sig
			WHEN .95   THEN V1
			WHEN .975  THEN V2
			WHEN .99   THEN V3
			WHEN .995  THEN V4
			WHEN .999  THEN V5
			WHEN .9995 THEN V6
			END
			FROM Stat_T_TableCriticalValues ORDER BY ABS( @degreesofFreedom-degreeOfFreedom)
			)
	RETURN @crit
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [Stat_GetTCriticalValue]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'Stat_GetTCriticalValue' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'Stat_GetTCriticalValue',  '1.1.2.1', 'Stat_GetTCriticalValue', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
