

--  ------------  Generated from [../../../Source/CommServer/Db/Function/SplitIDs.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SplitIDs'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SplitIDs]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SplitIDs]
  delete from GXDBVersions where name = 'SplitIDs' and type = 5
END
GO

	CREATE FUNCTION dbo.SplitIDs
	(
		@IDsList varchar(max)
	)
	RETURNS
	@ParsedList table
	(
		_ID bigint
	)
	AS
	BEGIN
		DECLARE @_ID varchar(64), @Pos int
		SET @IDsList = LTRIM(RTRIM(@IDsList))+ ','
		SET @Pos = CHARINDEX(',', @IDsList, 1)
		IF REPLACE(@IDsList, ',', '') <> ''
		BEGIN
			WHILE @Pos > 0
			BEGIN
				SET @_ID = LTRIM(RTRIM(LEFT(@IDsList, @Pos - 1)))
				IF @_ID <> ''
				BEGIN
					INSERT INTO @ParsedList (_ID)
					VALUES (CAST(@_ID AS bigint)) --Use Appropriate conversion
				END
				SET @IDsList = RIGHT(@IDsList, LEN(@IDsList) - @Pos)
				SET @Pos = CHARINDEX(',', @IDsList, 1)
			END
		END
		RETURN
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SplitIDs]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SplitIDs' AND revision = '1.3')

  insert into GXDBVersions values(5, 'SplitIDs',  '1.3', 'SplitIDs', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
