

--  ------------  Generated from [../../../Source/CommServer/Db/Function/SlowestClients.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SlowestClients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SlowestClients]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SlowestClients]
  delete from GXDBVersions where name = 'SlowestClients' and type = 5
END
GO

 CREATE FUNCTION SlowestClients(
	@TimeRangeBegin	INTEGER,
	@TimeRangeEnd	INTEGER,
	@TopN			INTEGER,
	@BackupType		VARCHAR(32),
	@CountAgedJobs	INTEGER
	)
 RETURNS @Results TABLE (
	CommServer		NVARCHAR(256),
	Client			NVARCHAR(256),
	ThroughputMBS	DECIMAL(20,2),
	NumberOfJobs	INT
 )
 AS
 BEGIN

 DECLARE @csName	VARCHAR(256) = (SELECT aliasName FROM APP_CommCell WHERE id = 2)

 IF @TimeRangeEnd <= 0
	SET @TimeRangeEnd = 0x7FFFFFFF

 IF	@TopN <= 0
 	SET @TopN = 0x7FFFFFFF

 DECLARE @tblBackupLevel TABLE (BackupLevel INT)

 IF @BackupType = 'Full'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(1)
	INSERT INTO @tblBackupLevel VALUES(1024)
	INSERT INTO @tblBackupLevel VALUES(32768)
 END
 ELSE IF @BackupType LIKE '%Synth%'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(64)
	INSERT INTO @tblBackupLevel VALUES(16384)
 END
 ELSE IF @BackupType LIKE '%Incr%'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(2)
	INSERT INTO @tblBackupLevel VALUES(4)
	INSERT INTO @tblBackupLevel VALUES(128)
	INSERT INTO @tblBackupLevel VALUES(256)
 END
 ELSE
	SET @BackupType = ''

 DECLARE @tblClientAggr TABLE (ClientId INT, AppSize BIGINT, Duration INT, NumberOfJobs INT)

 INSERT	INTO @tblClientAggr
 SELECT	clientId, SUM(totalUnCompBytes), SUM(totalWriteTime), COUNT(jobId)
 FROM	APP_Application A INNER JOIN JMBkpStats B ON A.id = B.appId
 WHERE	servEndDate BETWEEN @TimeRangeBegin AND @TimeRangeEnd
 	AND status IN (1, 3, 14) and opType IN (4, 14, 76) AND commCellId = 2
 	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700
  	AND (@BackupType = '' OR bkpLevel IN (SELECT BackupLevel FROM @tblBackupLevel))
 	AND (@CountAgedJobs = 1 OR dataStatus = 0)
 GROUP BY clientId

 INSERT	INTO @Results
 SELECT	TOP (@TopN)
 		@csName AS CommServer,
 		name AS Client,
 		(CASE WHEN Duration > 0 THEN ROUND(AppSize/Duration/1024.0/1024.0, 2) ELSE 0 END),
 		NumberOfJobs
 FROM	@tblClientAggr S INNER JOIN APP_Client C ON C.id = S.ClientId
 ORDER BY (CASE WHEN Duration > 0 THEN ROUND(AppSize/Duration/1024.0/1024.0, 2) ELSE 0 END)

 RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SlowestClients]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SlowestClients' AND revision = '1.3.198.1')

  insert into GXDBVersions values(5, 'SlowestClients',  '1.3.198.1', 'SlowestClients', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
