

--  ------------  Generated from [../../../Source/CommServer/Db/Function/SEGetAllIndexLocations.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: SEGetAllIndexLocations'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SEGetAllIndexLocations]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SEGetAllIndexLocations]
  delete from GXDBVersions where name = 'SEGetAllIndexLocations' and type = 5
END
GO

    CREATE FUNCTION SEGetAllIndexLocations(@CloudId INT, @ClientId INT)
    RETURNS @DataDirInfo TABLE (CloudId INT, ClientId INT, IndexLocation NVARCHAR(1024))
    AS
    BEGIN
		DECLARE @cloudType INT = 0
		SELECT TOP 1 @cloudType = CloudType FROM DM2SearchServerCoreInfo WITH(NOLOCK) WHERE CloudId = @CloudId
IF @cloudType = 3
		BEGIN
			INSERT INTO @DataDirInfo
			SELECT A.CloudId, A.ClientId, B.attrVal FROM DM2SearchServerCoreInfo A WITH(NOLOCK), APP_ClientProp B WITH(NOLOCK)
			WHERE A.CloudId = @CloudId AND (A.ClientId = @ClientId OR @ClientId = 0) AND A.ClientId = B.ComponentNameId AND B.attrName = 'FAST_index-dir' AND B.modified = 0
AND A.CloudType =  3
		END
		ELSE
		BEGIN
			INSERT INTO @DataDirInfo
			SELECT T.cloudId, N.ClientId, T.datadir FROM
			(
				SELECT cl.cloudId AS cloudId,ref.value('@value', 'NVARCHAR(1024)') AS datadir
				FROM DM2Cloud CL WITH(NOLOCK)
				CROSS APPLY (select CAST(CL.CloudProps AS xml)) as T(X)
				CROSS APPLY T.X.nodes('/CloudMetaProp/cloudMetaInfos') as R(ref)
				WHERE ref.value('@name', 'NVARCHAR(1024)')='INDEXLOCATION'
				AND (@CloudId = 0 or CL.cloudId = @CloudId)
			) T
			JOIN DM2SearchServerCoreInfo N WITH(NOLOCK) ON T.cloudId = N.CloudId
WHERE N.CloudType IN ( 1 , 5 ) AND
			(@CloudId = 0 or N.cloudId = @CloudId) and (@ClientId = 0  or N.ClientId = @ClientId)
			--if value available at node level, now we have to overwrite that..
			;WITH CTE
			AS
			(
				SELECT dm.cloudId AS cloudId,ref.value('@value', 'NVARCHAR(1024)') AS CacheLocation, DM.ClientId
				FROM DM2SearchServerCoreInfo DM WITH(NOLOCK)
				CROSS APPLY (select CAST(DM.NodeProps AS xml)) as T(X)
				CROSS APPLY T.X.nodes('/NodeMetaProp/nodeMetaInfos') as R(ref)
				WHERE ref.value('@name', 'NVARCHAR(1024)')='INDEXLOCATION'
AND DM.CloudType IN ( 1 , 5 )
				AND (@CloudId = 0 or DM.cloudId = @CloudId)
				AND (@ClientId = 0  or DM.ClientId = @ClientId)
			)
			MERGE @DataDirInfo AS O
			USING CTE AS A
				ON A.CloudId = O.CloudId AND A.ClientId = O.ClientId AND ISNULL(CacheLocation, '') NOT IN ('', 'NA')
			WHEN MATCHED
			THEN
				UPDATE SET O.IndexLocation = A.CacheLocation
			WHEN NOT MATCHED THEN
				INSERT (CloudId, ClientId , IndexLocation)
				VALUES (A.CloudId, A.ClientId, CacheLocation);
		END
		RETURN
    END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SEGetAllIndexLocations]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SEGetAllIndexLocations' AND revision = '1.1.2.5')

  insert into GXDBVersions values(5, 'SEGetAllIndexLocations',  '1.1.2.5', 'SEGetAllIndexLocations', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
