

--  ------------  Generated from [../../../Source/CommServer/Db/Function/RptGetLocalizedString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: RptGetLocalizedString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetLocalizedString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetLocalizedString]
  delete from GXDBVersions where name = 'RptGetLocalizedString' and type = 5
END
GO

    SET QUOTED_IDENTIFIER ON
    GO

		CREATE FUNCTION RptGetLocalizedString(@localeId INTEGER, @messageId INTEGER, @messageParams XML = NULL)
		RETURNS NVARCHAR(MAX)
		BEGIN
			DECLARE @MsgTxt		NVARCHAR(max)
			DECLARE @Data		NVARCHAR(max)
			DECLARE @MsgTxtTmp	NVARCHAR(max)
			DECLARE @ArgPos		INTEGER
			DECLARE @ArgIndex	INTEGER
			DECLARE @DataType	INTEGER
			DECLARE @HexFlag	INTEGER
			DECLARE @FullFmtSpecLen	INTEGER
			DECLARE @ParentMask	INTEGER

			SELECT @MsgTxt = Message
			FROM EvLocaleMsgs
			WHERE MessageId = @messageId
			AND LocaleId = @LocaleId

			IF @MsgTxt is null
			BEGIN
				SET @LocaleId = 0				-- If message id not found then try English

				SELECT @MsgTxt = Message
					FROM EvLocaleMsgs
					WHERE MessageId = @messageId
					AND LocaleId = @LocaleId

				IF @MsgTxt is null			-- If even English message not found then error out
				BEGIN
					RETURN @MsgTxt
				END
			END

			DECLARE @MsgArguments TABLE(paramPos INT, paramValue NVARCHAR(MAX))
			INSERT INTO @MsgArguments
			SELECT
				info.n.value('@paramPos', 'INT'),
				info.n.value('@paramValue', 'NVARCHAR(MAX)')
			FROM @messageParams.nodes('/MsgParams/msgParam') AS info(n)

			DECLARE GetTextPos CURSOR
			LOCAL FAST_FORWARD
			FOR	SELECT ArgPos, ArgIndex, DataType, HexFlag, FullFmtSpecLen
				FROM EvLocaleMsgArgInfo
				WHERE MessageId = @messageId
				AND LocaleId = @LocaleId
				ORDER BY ArgIndex DESC
			FOR READ ONLY

			OPEN GetTextPos

			FETCH NEXT FROM GetTextPos
			INTO @ArgPos, @ArgIndex, @DataType, @HexFlag, @FullFmtSpecLen

			WHILE @@FETCH_STATUS = 0
			BEGIN

				SELECT @Data = ''
				SELECT @Data = ISNULL(paramValue, '') FROM @MsgArguments WHERE paramPos = @ArgPos

				SET @MsgTxtTmp = @Data
				SET @Data = STUFF(@MsgTxt, @ArgIndex, @FullFmtSpecLen, @MsgTxtTmp)
				SET @MsgTxt = @Data		-- Putting this in one statement did not work, something gets overwritten

				FETCH NEXT FROM GetTextPos
				INTO @ArgPos, @ArgIndex, @DataType, @HexFlag, @FullFmtSpecLen
			END

			CLOSE GetTextPos
			DEALLOCATE GetTextPos

			RETURN @MsgTxt
		END
	GO

    SET QUOTED_IDENTIFIER ON
    GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetLocalizedString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetLocalizedString' AND revision = '')

  insert into GXDBVersions values(5, 'RptGetLocalizedString',  '', 'RptGetLocalizedString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
