

--  ------------  Generated from [../../../Source/CommServer/Db/Function/RptGetFailureReasonErrorCodeLink.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: RptGetFailureReasonErrorCodeLink'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetFailureReasonErrorCodeLink]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetFailureReasonErrorCodeLink]
  delete from GXDBVersions where name = 'RptGetFailureReasonErrorCodeLink' and type = 5
END
GO

 CREATE FUNCTION RptGetFailureReasonErrorCodeLink(@inputMsgs varchar(256), @localeId integer, @isHtml integer, @skipErrorCodeLink integer, @clId integer)
 RETURNS NVARCHAR(MAX)
 -- WITH ENCRYPTION
 AS
 BEGIN
	DECLARE @messages varchar(256)
	DECLARE @msgId varchar(40)
	DECLARE @endIndex integer
	DECLARE @startIndex integer
	DECLARE @EventId integer
	DECLARE @output nvarchar(MAX)
	DECLARE @MsgTxt nvarchar(MAX)
	DECLARE @subSystemName varchar(64)
	DECLARE @machineName varchar(64)
	DECLARE @errorCode   varchar(64)
	DECLARE	@kbLink VARCHAR(128)
	DECLARE	@bullet VARCHAR(8)
    DECLARE @machineDisplayName nvarchar(255)
	SET @startIndex = 0
	SET @messages = @inputMsgs
	SET @output = N''
    SET @machineDisplayName = N''
	SET @endIndex = CHARINDEX(',', @messages, @startIndex)
	IF (@endIndex IS NULL OR @endIndex = 0)
		RETURN @messages

    SELECT @machineDisplayName = displayName FROM APP_Client WITH (READUNCOMMITTED) WHERE id = @clId
	WHILE (@endIndex IS NOT NULL AND @endIndex <> 0)
	BEGIN
		SET @EventId = 0
		SET @msgId = SUBSTRING(@messages,@startIndex,@endIndex-@startIndex)
		SELECT @EventId = messageId, @subSystemName = subsystem, @machineName = client FROM JMFailureReasonMsg WITH (READUNCOMMITTED) WHERE id = @msgId
        IF (@machineDisplayName <>  N'')
            SET @machineName = @machineDisplayName

		IF (@EventId IS NOT null AND @EventId <> 0)
		BEGIN
			SET @MsgTxt = DBO.JMFormatPendingMsgText( @msgId, @localeId, @EventId, 1)
			IF  LEN(@machineName) <> 0
			BEGIN
				SET @MsgTxt = @MsgTxt + '<br>Source: ' + @machineName
				IF  LEN(@subSystemName) <> 0
					SET @MsgTxt = @MsgTxt + ', Process: ' + @subSystemName
			END
			IF @MsgTxt IS NOT null
			BEGIN
				IF  LEN(@output) <> 0
					SET @output = @output + NCHAR(10)

				SET @MsgTxt = REPLACE(@MsgTxt, NCHAR(10), NCHAR(13))
				SET @kbLink = 'http://kb.commvault.com/#!/?q='
				SET @errorCode = CAST(@EventId/16777216 AS VARCHAR(24)) + ':' + CAST(@EventId%16777216 AS VARCHAR(24))
				IF  @errorCode <> ''
					SET @kbLink += '%22' + @errorCode + '%22'
				IF  @isHtml > 0
					SET @output += ('<LI> ERROR CODE [<A target=\"_blank\" href="' + @kbLink + '">' + @errorCode + '</A>]: ' + @MsgTxt)
				ELSE
				IF  @skipErrorCodeLink > 0
					SET @output += ('# ERROR CODE [' + @errorCode + ']: ' + @MsgTxt + ' ')
				ELSE
					SET @output += ('# ERROR CODE [' + @errorCode + ']: ' + @MsgTxt + ' (Error Lookup Site: ' + @kbLink + ')   ')
			END
		END
		SET @startIndex = @endIndex + 1
		SET @endIndex = CHARINDEX(',', @messages, @startIndex)
	END
	RETURN @output
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetFailureReasonErrorCodeLink]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetFailureReasonErrorCodeLink' AND revision = '1.1.2.3')

  insert into GXDBVersions values(5, 'RptGetFailureReasonErrorCodeLink',  '1.1.2.3', 'RptGetFailureReasonErrorCodeLink', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
