

--  ------------  Generated from [../../../Source/CommServer/Db/Function/ReplaceHostNameInURL.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: ReplaceHostNameInURL'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ReplaceHostNameInURL]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ReplaceHostNameInURL]
  delete from GXDBVersions where name = 'ReplaceHostNameInURL' and type = 5
END
GO

CREATE FUNCTION ReplaceHostNameInURL(@URL NVARCHAR(2048), @oldHostName NVARCHAR(1024), @newHostName NVARCHAR(1024))
RETURNS NVARCHAR(2048)
-- WITH ENCRYPTION
AS
BEGIN
	declare @newURL NVARCHAR(2048)
	declare @startpos int = CHARINDEX('://',@URL)
	if ( @startpos = 0)
		SET @newURL = REPLACE (@URL, @oldHostName, @newHostName)
	ELSE
	BEGIN
		set @startpos = @startpos + 3
		SET @newURL = substring (@URL, 0, @startpos)
		declare @endPos int = CHARINDEX(':',@URL, @startpos)
		IF @endPos = 0
			SET @endPos = CHARINDEX('/',@URL, @startpos)
		IF @endPos = 0  -- in case URL doesn't contain : or /
			SET @endPos = LEN(@URL) + 1
		if substring (@URL,@startpos , @endPos-@startpos) = @oldHostName
			set @newURL += @newHostName + substring (@URL,@endPos , len (@URL) - @endPos +1)
		else
			set @newURL = @URL
	END
	RETURN @newURL
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ReplaceHostNameInURL]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ReplaceHostNameInURL' AND revision = '1.3.2.5')

  insert into GXDBVersions values(5, 'ReplaceHostNameInURL',  '1.3.2.5', 'ReplaceHostNameInURL', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
