

--  ------------  Generated from [../../../Source/CommServer/Db/Function/ProtectedClientsPerPolicy.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ProtectedClientsPerPolicy'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ProtectedClientsPerPolicy]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ProtectedClientsPerPolicy]
  delete from GXDBVersions where name = 'ProtectedClientsPerPolicy' and type = 5
END
GO

 CREATE FUNCTION ProtectedClientsPerPolicy (
	@TimeRangeBegin	INTEGER,
	@TimeRangeEnd	INTEGER,
	@CountAgedJobs	INTEGER
 )
 RETURNS @Results TABLE (
	CommCell		NVARCHAR(256),
	Policy			NVARCHAR(256),
	Client			NVARCHAR(256),
	CompletedJobs	INTEGER,
	SizeOnMediaGB	DECIMAL(20,2)
 )
 AS
 BEGIN

 DECLARE @csName	VARCHAR(256) = (SELECT aliasName FROM APP_CommCell WHERE id = 2)

 DECLARE @TotalSize	BIGINT

 IF @TimeRangeEnd <= 0
	SET @TimeRangeEnd = 0x7FFFFFFF

 DECLARE @tblClientSize TABLE (PolicyName NVARCHAR(144), ClientId INT, CompletedJobs INT, SizeOnMedia BIGINT)

 INSERT	INTO @tblClientSize
 SELECT	G.name, clientId, COUNT(DISTINCT B.jobId), SUM(D.sizeOnMedia)
 FROM	APP_Application A
 		INNER JOIN JMBkpStats B ON A.id = B.appId
 		INNER JOIN JMJobDataStats D ON D.jobId = B.jobId AND D.commCellId = B.commCellId
 		INNER JOIN archGroup G ON D.archGrpCopyId IN (G.defaultCopy, G.defaultSnapCopy)
 		INNER JOIN APP_iDAType I ON I.type = B.appType
 WHERE	B.servEndDate BETWEEN @TimeRangeBegin AND @TimeRangeEnd
 	AND (B.status IN (1, 14) OR B.status = 3 AND I.isCWEJobValid = 1)
 	AND B.opType IN (4, 14, 18, 59, 65, 76) AND B.commCellId = 2
 	AND B.appType < 1000 AND B.appType NOT BETWEEN 600 AND 700
 	AND (@CountAgedJobs = 1 OR B.dataStatus = 0)
 GROUP BY G.name, A.clientId

 INSERT	INTO @Results
 SELECT	@csName AS CommCell,
		S.PolicyName AS Policy,
 		C.name AS Client,
 		S.CompletedJobs,
 		ROUND(SizeOnMedia/1024.0/1024.0/1024.0, 2) AS SizeOnMediaGB
 FROM	@tblClientSize S INNER JOIN APP_Client C ON C.id = S.ClientId
 ORDER BY S.PolicyName, C.name

 RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ProtectedClientsPerPolicy]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ProtectedClientsPerPolicy' AND revision = '1.3.88.1')

  insert into GXDBVersions values(5, 'ProtectedClientsPerPolicy',  '1.3.88.1', 'ProtectedClientsPerPolicy', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
