

--  ------------  Generated from [../../../Source/CommServer/Db/Function/ProperCase.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ProperCase'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ProperCase]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ProperCase]
  delete from GXDBVersions where name = 'ProperCase' and type = 5
END
GO

 			CREATE FUNCTION ProperCase
 			(@string VARCHAR(255))
			RETURNS VARCHAR(255) AS
			BEGIN
			-- Declarations
			DECLARE @return VARCHAR(255)
			DECLARE @len INT
			DECLARE @finished BIT
			DECLARE @pos INT
			DECLARE @thischar CHAR(1)
			DECLARE @thisasc INT
			DECLARE @capitalise BIT
			-- Initialise
			SELECT @finished = 0
			SELECT @string = LOWER(@string)
			SELECT @return = @string
			SELECT @len = DATALENGTH(@return)
			-- Failsafe
			IF @len = 0
			SELECT @finished = 1
			-- Loop over all characters: capitalise first character and those after spaces, replace underscores with spaces
			SELECT @pos = 0
			SELECT @capitalise = 1
			WHILE @finished = 0
			BEGIN
			-- Next position in string
				SELECT @pos = @pos + 1
				-- Done?
				IF @pos > @len
					SELECT @finished = 1
				ELSE
				BEGIN
					-- Read this character
					SELECT @thischar = SUBSTRING(@return, @pos, 1)
					SELECT @thisasc = ASCII(@thischar)
					IF @thischar IN ('_', ' ')
					BEGIN
						SELECT @return = LEFT(@return, @pos - 1) + ' ' + RIGHT(@return, @len - @pos)
						SELECT @capitalise = 1
					END
					ELSE
					BEGIN
						IF @capitalise = 1 AND (@thisasc BETWEEN 97 AND 122)
						BEGIN
							SELECT @thisasc = @thisasc - 32
							SELECT @return = LEFT(@return, @pos - 1) + CHAR(@thisasc) + RIGHT(@return, @len - @pos)
							SELECT @capitalise = 0
						END
					END
				END
			END
			-- Done
			RETURN @return
			END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ProperCase]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ProperCase' AND revision = '1.3')

  insert into GXDBVersions values(5, 'ProperCase',  '1.3', 'ProperCase', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
