

--  ------------  Generated from [../../../Source/CommServer/Db/Function/PlanRuleGetFieldValuesForEntityV2.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: PlanRuleGetFieldValuesForEntityV2'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[PlanRuleGetFieldValuesForEntityV2]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[PlanRuleGetFieldValuesForEntityV2]
  delete from GXDBVersions where name = 'PlanRuleGetFieldValuesForEntityV2' and type = 5
END
GO

 SET QUOTED_IDENTIFIER ON
 GO
 CREATE FUNCTION [dbo].[PlanRuleGetFieldValuesForEntityV2](@entityId INT, @entityType INT)
 RETURNS @ruleFieldValues TABLE (appType INT, clientGroupId VARCHAR(MAX), regionId INT)
 AS
 BEGIN
 	IF (@entityId = 0)
     BEGIN
 		-- sad...
         RETURN
     END
 	ELSE
 	BEGIN
 		DECLARE	@clientId		INT = @entityId,
 				@appTypeId		INT,
 				@regionId		INT,
 				@clientGroupId	VARCHAR(1024),
 				@distance		FLOAT
 		DECLARE @regionDistance	TABLE(regionId INT PRIMARY KEY, distance float)
 		DECLARE @clientRegions	TABLE(regionId INT PRIMARY KEY, lat float, long float)
 		DECLARE @clientGroups	TABLE(clientGroupId INT PRIMARY KEY)
 		----- AgentType BEGIN ---------------------------------------------------------------------------------------------------------------
 		IF @entityType = 3 /*CLIENT_ENTITY*/
 			SELECT
 				@appTypeId = appTypeId
 			FROM APP_Application WITH(READUNCOMMITTED)
 			WHERE subclientName = 'default' AND subclientStatus = 10
 		ELSE
 		BEGIN
 			SELECT
 				@clientId = c.id, @appTypeId = a.appTypeId
 			FROM APP_Application a WITH(READUNCOMMITTED)
 				JOIN APP_Client c WITH(READUNCOMMITTED) ON a.clientId = c.id AND a.id = @entityId
 		END
 		----- AgentType END -----------------------------------------------------------------------------------------------------------------
 		----- ClientGroup BEGIN -------------------------------------------------------------------------------------------------------------
 		INSERT INTO @clientGroups
 				SELECT
 					g.clientGroupId
 				FROM APP_ClientGroupAssoc g WITH(READUNCOMMITTED)
 				WHERE g.clientId = @clientId
 		SET @clientGroupId = NULL
 		SELECT @clientGroupId = COALESCE(@clientGroupId + ',', '') + CAST(clientGroupId AS VARCHAR(1024)) FROM @clientGroups
 		SET @clientGroupId = ISNULL(@clientGroupId, '')
 		----- ClientGroup END ---------------------------------------------------------------------------------------------------------------
 		----- Region BEGIN ------------------------------------------------------------------------------------------------------------------
 		SET @regionId = dbo.PlanRuleGetAssociatedRegionForEntityV2(@entityId, @entityType, 1 /*findClosestRegion*/)
 		----- Region END --------------------------------------------------------------------------------------------------------------------
 		----- CREATE RESULT -----------------------------------------------------------------------------------------------------------------
 		INSERT INTO @ruleFieldValues
 			SELECT
 				@appTypeId, @clientGroupId, @regionId
 		----- CREATE RESULT -----------------------------------------------------------------------------------------------------------------
 	END
 	-- happy...
    RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [PlanRuleGetFieldValuesForEntityV2]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'PlanRuleGetFieldValuesForEntityV2' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'PlanRuleGetFieldValuesForEntityV2',  '1.1.2.1', 'PlanRuleGetFieldValuesForEntityV2', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
