

--  ------------  Generated from [../../../Source/CommServer/Db/Function/PlanRuleGetAssociatedRegionForEntityV2.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: PlanRuleGetAssociatedRegionForEntityV2'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[PlanRuleGetAssociatedRegionForEntityV2]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[PlanRuleGetAssociatedRegionForEntityV2]
  delete from GXDBVersions where name = 'PlanRuleGetAssociatedRegionForEntityV2' and type = 5
END
GO

 SET QUOTED_IDENTIFIER ON
 GO
 CREATE FUNCTION [dbo].[PlanRuleGetAssociatedRegionForEntityV2](@entityId INT, @entityType INT, @findClosest INT = 0)
 RETURNS INT
 AS
 BEGIN
 	IF (@entityId = 0)
     BEGIN
 		-- sad...
         RETURN -1
     END
 	ELSE
 	BEGIN
 		DECLARE	@clientId		INT = @entityId,
 				@regionId		INT = 0,
 				@distance		FLOAT
 		DECLARE @regionDistance	TABLE(regionId INT PRIMARY KEY, distance float)
 		DECLARE @clientRegions	TABLE(regionId INT PRIMARY KEY, lat float, long float)
 		DECLARE @clientGroups	TABLE(clientGroupId INT PRIMARY KEY)
 		-- GET CLIENT DETAILS
 		IF @entityType = 7
 		BEGIN
 			SELECT
 				@clientId = c.id
 			FROM APP_Application a WITH(READUNCOMMITTED)
 				JOIN APP_Client c WITH(READUNCOMMITTED) ON a.clientId = c.id AND a.id = @entityId
 		END
 		-- GET CLIENTGROUP DETAILS FOR THE CLIENT
 		INSERT INTO @clientGroups
 				SELECT
 					g.clientGroupId
 				FROM APP_ClientGroupAssoc g WITH(READUNCOMMITTED)
 				WHERE g.clientId = @clientId
 		----- Region BEGIN -----------------------------------------------------------------------------------------------------------------------------
 		-- get region tagged to the client
 		SELECT
 			@regionId = IIF(ISNUMERIC(CONVERT(NVARCHAR(MAX), value)) = 1, CONVERT(INT, CONVERT(NVARCHAR(MAX), value)), 0)
 		FROM APP_AdvanceSettings -- No dirty reads
 		WHERE entityId = @clientId and entityType = 3/*CLIENT_ENTITY*/
 		AND sourceId = 0 /*set on client directly*/ AND keyName = 'Region ID' AND enabled = 1 AND deleted = 0
 		-- IF NOT FOUND THEN GET REGIONS INHERITED FROM CLIENT GROUPS
 		IF @regionId = 0 AND @findClosest = 1
 		BEGIN
 			INSERT INTO @clientRegions
 				SELECT
 					r.regionId, r.latitude, r.longitude
 				FROM APP_AdvanceSettings s WITH(READUNCOMMITTED)
 					JOIN @clientGroups g
 						ON s.entityId = g.clientGroupId AND s.entityType = 28/*CLIENT_GROUP_ENTITY*/ AND keyName = 'Region ID'
 					JOIN App_Region r WITH(READUNCOMMITTED)
 						ON CAST(value AS NVARCHAR(MAX)) = CAST(r.regionId AS NVARCHAR(MAX))
 				WHERE s.enabled = 1 AND s.deleted = 0
 			-- GET CLIENT'S GEO LOCATION
 			DECLARE @lat float, @long float, @location XML
 			SELECT
 				@location = attrVal
 			FROM APP_ClientProp WITH(READUNCOMMITTED)
 			WHERE attrName = 'Client Geo Location' AND componentNameId = @clientId
 				AND modified = 0
 			set @lat = @location.value('(.//@latitude)[1]', 'float')
 			set @long = @location.value('(.//@longitude)[1]', 'float')
 			-- CALCULATE CLOSEST REGION BASED ON GEO LOCATION
 			INSERT INTO @regionDistance
 				SELECT
 					g.regionId, MIN(dbo.APPComputeGeoDistance(@lat, @long, g.lat, g.long, default)) AS distance
 				FROM @clientRegions g
 				GROUP BY g.regionId
 				ORDER BY distance
 			-- get the id of the closest region
 			SET @regionId = ISNULL((SELECT TOP 1 regionId FROM @regionDistance order by distance), 0)
 		END
 		----- Region END -------------------------------------------------------------------------------------------------------------------------------
 	END
 	-- happy...
    RETURN @regionId
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [PlanRuleGetAssociatedRegionForEntityV2]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'PlanRuleGetAssociatedRegionForEntityV2' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'PlanRuleGetAssociatedRegionForEntityV2',  '1.1.2.1', 'PlanRuleGetAssociatedRegionForEntityV2', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
