

--  ------------  Generated from [../../../Source/CommServer/Db/Function/PlanRuleEvaluateV2.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: PlanRuleEvaluateV2'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[PlanRuleEvaluateV2]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[PlanRuleEvaluateV2]
  delete from GXDBVersions where name = 'PlanRuleEvaluateV2' and type = 5
END
GO

 SET QUOTED_IDENTIFIER ON
 GO
 CREATE FUNCTION [dbo].[PlanRuleEvaluateV2](@ruleId INT, @entityValues XML)
 RETURNS INT
 AS
 BEGIN
	-- Evaluation will to be done on following rule fields and if all matches the the rule is considered to be a match.
 	-- rank property of the rule will be used for tie breaker.
 		-- regionIds
 		-- agentTypeIds
 		-- clientGroupId
 	IF @ruleId = 0
 		RETURN 0
 	DECLARE @isSuccess		INT = 0,
 			@cRegionId		INT = 0 /*Default to invlaid*/,
 			@cAgentType		INT = 0,
 			@cGroupIds		VARCHAR(1024),
 			@rGroupId		INT
 	DECLARE	@rAgentIds		XML,
 			@rRegionIds		XML
	DECLARE	@rAgentTypeIds	TABLE(appTypeId INT) --Table to hold the expanded appGroups
 	----- Get subClient details ---------------------------------------------------------------------------------------------------
 	Select
 		@cRegionId	= ISNULL(ref.value('@regionId', 'int'), 0),
 		@cAgentType = ISNULL(ref.value('@agentTypeId', 'int'), 0),
 		@cGroupIds	= ISNULL(ref.value('@groupIds', 'VARCHAR(1024)'), '')
 	FROM @entityValues.nodes('/Values') doc(ref)
 	----- Get subClient details END -----------------------------------------------------------------------------------------------
 	----- Get rule details --------------------------------------------------------------------------------------------------------
 	SELECT
 		@rRegionIds		= regionIds,
 		@rGroupId		= clientGroupId,
 		@rAgentIds		= agentTypeIds
 	FROM App_PlanRule WITH(READUNCOMMITTED)
 	WHERE ruleId = @ruleId
	-- expand appGroups (if any) to appTypeIds
	INSERT INTO @rAgentTypeIds
		SELECT
			ag.appTypeId
		FROM @rAgentIds.nodes('//agentGroup') AppGroup(ref)
			JOIN APP_AppTypeGroupAssoc ag WITH(READUNCOMMITTED) ON ag.appGroupId = ref.value('@appGroupId', 'INT')
 	----- Get rule details --------------------------------------------------------------------------------------------------------
 	----- Evaluate rule -----------------------------------------------------------------------------------------------------------
 	-------------------- region evaluation ---------------------------------------------------
 	IF	(@rRegionIds.exist('//region[@regionId>0]') = 0 /*evaluates to ANY region*/
 		OR @rRegionIds.exist('//region[@regionId=sql:variable("@cRegionId")]') = 1)
 		SET @isSuccess = 1
 	-------------------- region evaluation ---------------------------------------------------
 	-------------------- agent evaluation  ---------------------------------------------------
 	IF @isSuccess = 1
 	BEGIN
 		IF	(
				@rAgentIds.exist('//agent[@applicationId>0]') = 0 /*evaluates to ANY appType*/
				OR @rAgentIds.exist('//agentGroup[@appGroupId>0]') = 0 /*evaluates to ANY appGroup*/
 				OR @rAgentIds.exist('//agent[@applicationId=sql:variable("@cAgentType")]') = 1 /*exact match*/
				OR (EXISTS (SELECT 1 FROM @rAgentTypeIds WHERE appTypeId = @cAgentType)) /*part of any appGroup*/
			)
	 		SET @isSuccess = 1
		ELSE
			SET @isSuccess = 0
 	END
 	-------------------- agent evaluation  ---------------------------------------------------
 	-------------------- CGroup evaluation ---------------------------------------------------
 	IF @isSuccess = 1
 	BEGIN
 		IF @rGroupId <> 0/*ANY group*/
 		AND NOT EXISTS (SELECT
 							CAST(_ID AS INT)
 						FROM dbo.SplitIDString(@cGroupIds)
 						WHERE @rGroupId = CAST(_ID AS INT))
 			SET @isSuccess = 0
 	END
 	-------------------- CGroup evaluation ---------------------------------------------------
 	----- Evaluate rule -----------------------------------------------------------------------------------------------------------
 	RETURN @isSuccess
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [PlanRuleEvaluateV2]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'PlanRuleEvaluateV2' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'PlanRuleEvaluateV2',  '1.1.2.1', 'PlanRuleEvaluateV2', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
