

--  ------------  Generated from [../../../Source/CommServer/Db/Function/NormalizeForXML.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: NormalizeForXML'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NormalizeForXML]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NormalizeForXML]
  delete from GXDBVersions where name = 'NormalizeForXML' and type = 5
END
GO

	CREATE FUNCTION NormalizeForXML(@string NVARCHAR(4000))
	RETURNS NVARCHAR(4000)
	AS BEGIN

	    DECLARE @rv  NVARCHAR(4000) = N''
	    DECLARE @len INT = LEN(@string)
	    DECLARE @i   INT = 1

	    WHILE @i <= @len BEGIN
	        DECLARE @char NCHAR(1) = SUBSTRING(@string, @i, 1)
	        -- all chacters with UNICODE code less then 32 are invalid except <CR>, <LF> and <TAB>; 0XFFFE and 0XFFFF are invalid also
	        IF((UNICODE(@char) < 0x20) AND UNICODE(@char) <> 0x9 AND UNICODE(@char) <> 0xA AND UNICODE(@char) <> 0xD) or (UNICODE(@char) = 0xFFFF) or (UNICODE(@char) = 0xFFFE)
	            SET @rv += '&#' + CAST(UNICODE(@char) AS NVARCHAR(24))
	        ELSE
	            SET @rv += @char
	        SET @i += 1
	    END

		-- Return the result of the function
		RETURN @rv
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NormalizeForXML]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NormalizeForXML' AND revision = '1.2.206.1')

  insert into GXDBVersions values(5, 'NormalizeForXML',  '1.2.206.1', 'NormalizeForXML', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
