

--  ------------  Generated from [../../../Source/CommServer/Db/Function/NTIsAlertTypeSupportedForEntity.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: NTIsAlertTypeSupportedForEntity'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTIsAlertTypeSupportedForEntity]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NTIsAlertTypeSupportedForEntity]
  delete from GXDBVersions where name = 'NTIsAlertTypeSupportedForEntity' and type = 5
END
GO

CREATE FUNCTION NTIsAlertTypeSupportedForEntity (@alertTypeId INT, @entityType INT)
RETURNS INTEGER
AS
BEGIN
-- EntityType is 0 means all entities. So all alerts are supported.
if @entityType=0
begin
	return 1
end
-- For alert Type 70 , NT_ALERTTYPE_USERS we support clientType subscription.. Corresponds to EvEntities.x entitytype enum.
if (@alertTypeId=70 and (@entityType=2 or @entityType=3))
begin
	return 1
end
if exists(select 1 from NTalertNodeTypeMap with (nolock) where NTalertTypeID=@alertTypeId and nodeType=@entityType)
begin
	return 1
end
return 0
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NTIsAlertTypeSupportedForEntity]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NTIsAlertTypeSupportedForEntity' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'NTIsAlertTypeSupportedForEntity',  '1.1.2.2', 'NTIsAlertTypeSupportedForEntity', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
