

--  ------------  Generated from [../../../Source/CommServer/Db/Function/NTGetUsersforSubscriptionAlert.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: NTGetUsersforSubscriptionAlert'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTGetUsersforSubscriptionAlert]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NTGetUsersforSubscriptionAlert]
  delete from GXDBVersions where name = 'NTGetUsersforSubscriptionAlert' and type = 5
END
GO

	CREATE FUNCTION NTGetUsersforSubscriptionAlert(@notifId integer, @clientId integer, @escLevel integer,@clientInAlertEntityList integer)
	RETURNS
	@userSubscriptionListFinal table (userId int)
	-- WITH ENCRYPTION
	AS
	BEGIN
	IF NOT EXISTS (select 1 from NTnotificationRule where [ID] = @notifId and (status & 128)>0)
	begin
		return
	end

	declare @RecepientsList table
	(
		userId		int,
		type		int
	)

	declare @userSubscription table
	(
		userId int,
		flags int,
		preferenceLevel int
	)

	INSERT @RecepientsList(userId, type)
	SELECT	userId, 0
	FROM	sec_getClientOwnersConfig owners
	WHERE	owners.clientId = @clientId and userId <> 0
	UNION
	SELECT UG.userId,0
	FROM   sec_getClientOwnersConfig AS owners, UMuserGroup as UG, UMgroups as G
	WHERE  owners.clientID = @clientId
	  AND ((owners.userGroupId <> 0 AND owners.userGroupId = G.id) OR (owners.externalGroupId <> 0 AND owners.externalGroupId = G.id))
	  AND G.id = UG.groupId
	  AND (G.groupFlags & 0x0001) = 0x0001			--'GF_GROUP_ENABLED'
	UNION
	SELECT UMDSUG.userid,0
	FROM sec_getClientOwnersConfig AS owners, UMDSGroups as UEG,UMDSUserGroup UMDSUG,UMDSGroupMaps UMDSGM,
	UMGroups AS G
	WHERE owners.usergroupId = UMDSGM.umgroupId
	  AND owners.clientId = @clientId
	  AND UMDSGM.umDSgroupId = UMDSUG.groupId
	  AND  G.id       = UMDSGM.umgroupId
	  AND  ((G.groupFlags & 1) =1)

	-- Now that client owners are retrieved, we will remove users who dont wish to be notified.

	-- First we give preference to users
	Insert into @userSubscription
	select userId,flags,0 from NTAlertSubScriptions
	where ntRuleId=@notifId
	and @clientId = entityId1
	and entityType1 = 3
	and @clientId > 0
	and escalationLevel = @escLevel

	Insert into @userSubscription
	select userId,flags,1 from NTAlertSubScriptions
	where ntRuleId=@notifId
	and entityId1 = 0
	and entityType1 = 3
	and escalationLevel = @escLevel

	-- First we check whether that client is a dlo client.
	if exists(select  1 from App_client
	where (STATUS & 0x1000)>0
		and id=@clientId)
	begin
		-- Then check whether this client is part of entity selection list for this alert.

		if @clientInAlertEntityList=1
		begin
			Insert into @userSubscription
			-- Now we want to enable subscription based alert for all users by default even if they havent made any selection from webconsole.
			select ClientOwners.userId,1,2 from @RecepientsList ClientOwners
			left join NTAlertSubScriptions on
			NTAlertSubScriptions.userId = ClientOwners.userId and
			NTAlertSubScriptions.ntRuleId = @notifId and
			(NTAlertSubScriptions.entityId1 = @clientId Or NTAlertSubScriptions.entityId1= 0) and NTAlertSubScriptions.entityType1=3
			where ClientOwners.userId <> 0
			and @clientId > 0
			and NTAlertSubScriptions.ntRuleId is null
		end
	end
	-- Retrieve users who want to get notified. And remove the rest.
	delete from @RecepientsList
	where userId not in
	(
		select userId from
		(
			select userId,flags,
			Rank() over (Partition by userId Order by preferenceLevel) as rowNo
			from @userSubscription
		) t
		where rowNo = 1
		and ((flags & 1)>0)
	) and type=0

	delete from @userSubscriptionListFinal
	Insert into @userSubscriptionListFinal
	select userId from @RecepientsList
		RETURN
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NTGetUsersforSubscriptionAlert]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NTGetUsersforSubscriptionAlert' AND revision = '1.3.42.4')

  insert into GXDBVersions values(5, 'NTGetUsersforSubscriptionAlert',  '1.3.42.4', 'NTGetUsersforSubscriptionAlert', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
