

--  ------------  Generated from [../../../Source/CommServer/Db/Function/NTGetUsersForAlertRule.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: NTGetUsersForAlertRule'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTGetUsersForAlertRule]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NTGetUsersForAlertRule]
  delete from GXDBVersions where name = 'NTGetUsersForAlertRule' and type = 5
END
GO

CREATE FUNCTION NTGetUsersForAlertRule ( @ruleId INTEGER, @escalationLevel INTEGER, @messType INTEGER , @laptopClientId INTEGER, @userList XML)
RETURNS
       @reciepientDetails table(
	                userId      int,
					Login       nvarchar(510),
					UserName    nvarchar(510),
					Email       nvarchar(510),
					recipientType	int	default 0
				               )
-- WITH ENCRYPTION
AS
BEGIN
	-- 0 means ToUserId, 1 means userGroup, 2 means non galaxy username...
	DECLARE @isOwnerReporting as integer =  0
    	DECLARE @isMetricsAlarm   as integer =  0
	DECLARE @alertTypeForAlert as integer =  0
	DECLARE @recipientTypeForSubsAlert as integer =  0
	select @alertTypeForAlert = alertTypeId
	from NTNotificationrule with (readuncommitted) where [ID] = @ruleId
	IF EXISTS (
		SELECT * FROM NTNotificationQueryMapping
		INNER JOIN NTQueryList
		ON NTNotificationQueryMapping.QueryId = NTQueryList.queryId
		WHERE NtNotificationId = @ruleId
		AND status & 32 <>0
		)
	SET @isMetricsAlarm = 1
	IF (   (@messType = 1) AND ( @isMetricsAlarm = 1 )  )
	BEGIN
		INSERT INTO @reciepientDetails
		SELECT NULL ,NULL, NULL ,nonGalaxyUserName,recipientType
		FROM  NTNotificationNonGalaxyUsers
		WHERE NTnotificationID = @ruleId
		RETURN
	END
IF EXISTS (select 1 from NTnotificationRule where [ID] = @ruleId and (status & 128)>0)
	    SET @isOwnerReporting = 1
	DECLARE  @recepientsList TABLE
	(
		userId      int,
		Login       nvarchar(510),
		UserName    nvarchar(510),
		type        int,
		Email       nvarchar(510),
		recipientType	int
	)
IF  @messType in (1, 8192 , 262144, 1048576 )
	BEGIN
        IF (@isOwnerReporting <> 0) -- For edge drive quota criteria, alert may be subscription based and no client maybe associated. So recipient will be user alone.
		-- For drive share alerts which are subscription based, recipient list is sent in user Id token.
        BEGIN
if @alertTypeForAlert=72
		begin
			set @recipientTypeForSubsAlert = 2
		end
		-- For subscription based alerts of drive share alert type, we put recipients in bcc
		INSERT @recepientsList(userId, type, recipientType)
		SELECT  ref.value('@userId', 'int') AS Agent, 0, @recipientTypeForSubsAlert
			FROM    @userList.nodes('App_Associations/entity') R ( ref )
        END
		IF (@isOwnerReporting <> 0 and @lapTopClientId>0)         --'NT_STATUS_LAPTOP_ALERT'
		BEGIN                               -- NEED TO FETCH EMAILS FROM USERS/GROUPS WHO "OWN" THE CLIENT
			INSERT @recepientsList(userId, type)
			SELECT  userId, 0
			FROM    sec_getClientOwnersExpandUG owners
			WHERE   owners.clientId = @lapTopClientId and owners.userId <> 0
			-- Now that client owners are retrieved, we will remove users who dont wish to be notified.
			declare @userSubscription table
			(
				userId int,
				flags int,
				preferenceLevel int
			)
			-- First we give preference to users
			Insert into @userSubscription
			select userId,flags,0 from NTAlertSubScriptions
			where ntRuleId=@ruleId
			and EntityId1 = @lapTopClientId
			and EntityType1=3
			and @lapTopClientId > 0
			and escalationLevel = @escalationLevel
			Insert into @userSubscription
			select userId,flags,1 from NTAlertSubScriptions
			where ntRuleId=@ruleId
			and EntityId1 = 0
			and (EntityType1=3 OR EntityType1=0)
			and escalationLevel = @escalationLevel
			-- First we check whether that client is a dlo client.
			if exists(select  1 from App_client
where (STATUS & 0x1000)>0
			and id=@lapTopClientId)
			begin
				-- Then check whether this client is part of entity selection list for this alert.
				declare @genericEntity nvarchar(max)
				declare @resultMatch int = 0
				set @genericEntity = '<CvEntities_GenericEntity clientId="'+convert(nvarchar(10),@lapTopClientId)+'"/>'
				declare @subscripNTRuleXmlEntityList xml
				select @subscripNTRuleXmlEntityList = xmlEntityList from NTNotificationRule
				where id=@ruleId
				declare @entityCheckResult table
				(
					result int
				)
				set @subscripNTRuleXmlEntityList = @subscripNTRuleXmlEntityList.query('CVGui_CommCellTreeNode/associations')
				set @subscripNTRuleXmlEntityList = convert(xml,replace(replace(convert(nvarchar(max),@subscripNTRuleXmlEntityList),
				'<associations','<entity'),'</associations>','</entity>'))
				set @subscripNTRuleXmlEntityList = (
				select @subscripNTRuleXmlEntityList.query('.')
				for xml path(''),root('App_Associations')
				)
				if dbo.IsEntityInAssocList( @genericEntity,@subscripNTRuleXmlEntityList,@ruleId) = 1
				begin
					Insert into @userSubscription
					-- Now we want to enable subscription based alert for all users by default even if they havent made any selection from webconsole.
select ClientOwners.userId,1,2 from @recepientsList ClientOwners
					left join NTAlertSubScriptions on
					NTAlertSubScriptions.userId = ClientOwners.userId and
					NTAlertSubScriptions.ntRuleId = @ruleId and
					(NTAlertSubScriptions.entityId1 = @lapTopClientId Or NTAlertSubScriptions.entityId1 = 0) and
					(NTAlertSubScriptions.entityType1 = 3 OR NTAlertSubScriptions.entityType1=0)
					where ClientOwners.userId <> 0
					and @lapTopClientId > 0
					and NTAlertSubScriptions.ntRuleId is null
				end
			end
			-- Retrieve users who want to get notified. And remove the rest.
			delete from @recepientsList
			where userId not in
			(
				select userId from
				(
					select userId,flags,
					Rank() over (Partition by userId Order by preferenceLevel) as rowNo
					from @userSubscription
				) t
				where rowNo = 1
and ((flags & 1)>0)
			)
			and type=0
			-- IF @lapTopClientId = 0 .. NEED TO ABORT OUT SOMEHOW?
			-- TODO, FLUSH OUT GETTING EMAIL RECEPIENTS BASED ON A JOIN WITH TABLE "UMUserandGroupEntityAssociation".
			-- .. (Should be a mimic of code to retrieve from NT tables below)
		END
		ELSE IF (@isOwnerReporting = 0)
		BEGIN                       -- NOT A LAPTOP ALERT, FETCH EMAILS STORED WITH ALERT ITSELF
			INSERT INTO   @recepientsList(userId,type,recipientType)
			SELECT NU.userId,0,NU.recipientType
			FROM NTnotificationUsers AS NU
			WHERE NU.NTnotificationId = @ruleId
			AND NU.escalationLevel = @escalationLevel
			UNION
			-- get the users associated to the local user group
			SELECT UG.userId,0,NG.recipientType
			FROM NTnotificationGroups AS NG, UMUserGroup as UG, UMGroups as G
			WHERE NTnotificationId = @ruleId   AND escalationLevel = @escalationLevel
			AND G.Id = UG.groupId
			AND NG.groupId = UG.groupId
AND (G.groupFlags & 0x0001) = 0x0001          --'GF_GROUP_ENABLED'
AND (G.groupFlags & 0x0010) = 0
			UNION
			--get the ids of AD groups mapped to the local usergroup
			SELECT Map.umDSgroupId, 1, NG.recipientType
			FROM NTnotificationGroups AS NG
			INNER JOIN UMDSGroupMaps AS Map ON NG.groupId = Map.umgroupId AND NTnotificationId = @ruleId   AND escalationLevel = @escalationLevel
			INNER JOIN UMGroups as G ON G.id = Map.umDSgroupId
WHERE (G.groupFlags & 0x0001) = 0x0001          --'GF_GROUP_ENABLED'
AND (G.groupFlags & 0x0010) = 0
			UNION
			-- get the ids of selected AD groups
			SELECT NEG.externalGroupId, 1, NEG.recipientType
			FROM NTnotificationExternalGroups AS NEG
			INNER JOIN UMGroups as UG ON NEG.externalGroupId = UG.id AND  NTnotificationId = @ruleId AND escalationLevel = @escalationLevel
INNER JOIN UMDSProviders Prov ON Prov.id = UG.umdsproviderId AND Prov.serviceType <> 5
WHERE (UG.groupFlags & 0x0001) = 0x0001
AND (UG.groupFlags & 0x0010) = 0
			UNION
			--get the users from the organization groups
			SELECT UUG.userId, 0, NEG.recipientType
			FROM NTnotificationExternalGroups AS NEG
			INNER JOIN UMGroups as UG ON UG.id = NEG.externalGroupId AND NTnotificationId = @ruleId AND escalationLevel = @escalationLevel
INNER JOIN UMDSProviders Prov ON Prov.id = UG.umdsproviderId AND Prov.serviceType = 5
			INNER JOIN UMUserGroup UUG ON UUG.groupId = UG.id
WHERE (UG.groupFlags & 0x0001) = 0x0001
AND (UG.groupFlags & 0x0010) = 0
			-- Inserting the non-galaxy user information
			INSERT INTO   @recepientsList(type,Email,recipientType)
			SELECT 2,NNG.nonGalaxyUserName,recipientType FROM NTnotificationNonGalaxyUsers NNG
			WHERE NTnotificationId = @ruleId   AND escalationLevel = @escalationLevel
		END
	END
	------------------------------------------------------------------------
	-- WE'VE ALREADY FILTERED OUT GROUPS THAT ARE DISABLED, BUT NOW PRUNE --
	-- RECEPIENTS LIST OF USERS THAT ARE DISABLED                        --
	------------------------------------------------------------------------
	DeLeTe @recepientsList
	FROM  @recepientsList AS RL, UMUsers as U
	WHERE RL.userID = U.id
	AND RL.type = 0
AND (U.enabled = 0 OR (U.flags & 0x004) = 0x004)
IF ( @messType = 1  OR @messType = 262144 )
	BEGIN
		UPDATE @recepientsList
		SET login = US.login, UserName = US.name, Email=US.Email
		FROM @recepientsList as RL, UMUsers AS US
		WHERE RL.userId = US.id AND RL.type = 0
		-- External Groups
		UPDATE @recepientsList
		SET login = UEG.name, UserName = UEG.name, Email=UEG.Email
		FROM @recepientsList as RL, UMDSGroups AS UEG
		WHERE RL.userId = UEG.id AND RL.type = 1
        END
IF  @messType  = 8192 OR @messType = 1048576
	BEGIN
		INSERT INTO  @recepientsList (userId,type)  -- Type 2 for expanded users
		SELECT UMUserGroup.userId , 0 FROM @recepientsList  AS RL
		INNER JOIN UMUserGroup ON RL.userId  =  UMUserGroup.groupId
                WHERE RL.type = 1
	END
IF  @messType  = 262144
    BEGIN
        --  No need to process any users without emailID
        delete @recepientsList where Email = '' or email is null
    END
	UPDATE @recepientsList
	SET userId = NULL
	WHERE type = 1
	INSERT INTO @reciepientDetails
	SELECT userId ,Login, UserName ,Email,recipientType   FROM @recepientsList
RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NTGetUsersForAlertRule]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NTGetUsersForAlertRule' AND revision = '1.3.12.15')

  insert into GXDBVersions values(5, 'NTGetUsersForAlertRule',  '1.3.12.15', 'NTGetUsersForAlertRule', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
