

--  ------------  Generated from [../../../Source/CommServer/Db/Function/NTGetPossibleCausesForLongRunTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: NTGetPossibleCausesForLongRunTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTGetPossibleCausesForLongRunTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NTGetPossibleCausesForLongRunTime]
  delete from GXDBVersions where name = 'NTGetPossibleCausesForLongRunTime' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION NTGetPossibleCausesForLongRunTime(@jobId BIGINT,@forReport INT,@localeId INT)
RETURNS NVARCHAR(MAX)
AS
BEGIN
		DECLARE @lastBackupTime BIGINT = 0
		DECLARE @lastBackupSize BIGINT = 0
		DECLARE @backupSize BIGINT = 0
		DECLARE @subclientId INT = 0
		DECLARE @opType INT = 0
		DECLARE @backupLvl INT = 0
		DECLARE @msgString NVARCHAR(1024) = ''
		DECLARE @increaseInPercent INT = 0
		DECLARE @possibleCause NVARCHAR(4000) = ''
		DECLARE @eventsTable table(eventId int, timeSource int, messageId integer,anomalous integer, severity int)
		DECLARE @eventsMap table(eventId int, msgId int)
		DECLARE @existingReason NVARCHAR(512) = ''
		DECLARE @reasonsThatDoesntRequireFurtherSearch TABLE(reasonId INT)
		DECLARE @isJPRSufficient INT = 0
		INSERT INTO @reasonsThatDoesntRequireFurtherSearch
VALUES ((1131 | (CAST(POWER(2, 24) AS BIGINT) * 19))),((1597 | (CAST(POWER(2, 24) AS BIGINT) * 19))),
((106 | (CAST(POWER(2, 24) AS BIGINT) * 19))),((531 | (CAST(POWER(2, 24) AS BIGINT) * 19))),
((207 | (CAST(POWER(2, 24) AS BIGINT) * 19))),((518 | (CAST(POWER(2, 24) AS BIGINT) * 19))),
((2 | (CAST(POWER(2, 24) AS BIGINT) * 10)))
		SELECT @subclientId = applicationId, @optype = opType, @backupLvl = bkpLevel, @backupSize = uncompbytestoxfer , @existingReason = failureReason
		FROM RunningBackups WHERE jobId = @jobId
		IF EXISTS(SELECT 1 FROM dbo.splitids(@existingReason) JPR
					INNER JOIN JMFailureReasonMsg JMFR WITH(NOLOCK) ON JPR._ID = JMFR.id
					INNER JOIN @reasonsThatDoesntRequireFurtherSearch DRFS ON DRFS.reasonId = JMFR.messageId)
			SET @isJPRSufficient = 1
		-- Job is not running or if possible cause is not required, return
		IF @subclientId = 0 OR @isJPRSufficient = 1
		 RETURN @possibleCause
		-- Check for phase attempt failures
		IF @existingReason = ''
		BEGIN
			DECLARE @phaseFailures TABLE(phaseNum INT, phaseName NVARCHAR(128), attempts INT, failureReason NVARCHAR(1024),message NVARCHAR(MAX))
			DECLARE @phaseFailureMsg TABLE (phaseNum INT, failureMsgId NVARCHAR(128),failureMsg NVARCHAR(1024))
			INSERT INTO @phaseFailures
				SELECT phaseNum, cast(phaseName as varchar), COUNT(1), '',''
				FROM JMBkpAttemptInfo WITH(NOLOCK)
				WHERE jobID = @jobId AND status = 2 -- CVJobStatus_FAIL
				GROUP BY phaseNum, cast(phaseName as varchar)
			INSERT INTO @phaseFailureMsg
				SELECT phaseNum, failureReason, ''
				FROM  JMBkpAttemptInfo WITH(NOLOCK)
				WHERE jobID = @jobId AND status = 2 -- CVJobStatus_FAIL
			UPDATE @phaseFailureMsg SET failureMsg = dbo.JMGetLocalizedMessageMaxFunc(@localeid, failureMsgId)
			WHERE failureMsgId IS NOT NULL
			;WITH cte AS
			(
				SELECT *, DENSE_RANK()  OVER(PARTITION BY A.phaseNum ORDER BY A.cnt DESC)R
				FROM (SELECT failureMsg, phaseNum, COUNT(1) AS cnt
						FROM @phaseFailureMsg
						WHERE LEN(failureMsg)>0
						GROUP BY failureMsg, phaseNum) A
			)
			UPDATE PF SET PF.failureReason = cte.failureMsg
			FROM @phaseFailures PF
			INNER JOIN CTE on Pf.phaseNum = cte.phaseNum AND cte.R=1
UPDATE @phaseFailures SET message = (SELECT message FROM EvLocaleMsgs WITH(NOLOCK) WHERE messageId = (1616 | (CAST(POWER(2, 24) AS BIGINT) * 83)) and localeID= @localeId)
			UPDATE @phaseFailures SET message = REPLACE(REPLACE(REPLACE(message,'^1%s',phaseName),'^2%d',attempts),'^3%s',failureReason)
			IF EXISTS(SELECT 1 FROM @phaseFailures WHERE message IS NOT NULL AND message <> '')
			BEGIN
				SELECT @possibleCause+= message + '<br><br>' FROM @phaseFailures WHERE message IS NOT NULL
			END
		END
		--1. Possible causes from events associated with jobs like suspended jobs, operation window, backup disabled, anomalous events
		IF(LEN(@possibleCause) = 0)
		BEGIN
			INSERT INTO @eventsMap	VALUES
((1054 | (CAST(POWER(2, 24) AS BIGINT) * 19)),(1611 | (CAST(POWER(2, 24) AS BIGINT) * 83))),
((1055 | (CAST(POWER(2, 24) AS BIGINT) * 19)),(1608 | (CAST(POWER(2, 24) AS BIGINT) * 83))),
((1056 | (CAST(POWER(2, 24) AS BIGINT) * 19)),(1607 | (CAST(POWER(2, 24) AS BIGINT) * 83)))
			-- list of event associated with the job
			INSERT INTO @eventsTable
				SELECT id,timeSource,messageId,anomalous,severity FROM EvMsg WITH (NOLOCK) WHERE ((POWER(CONVERT(BIGINT, 2), 32) * jobId_h + jobId_l) = @jobId)
			DECLARE @suspendedResumedTable table(messageId int, resumedTime int, suspendedTime int,message NVARCHAR(1024))
			INSERT INTO @suspendedResumedTable
				 SELECT A.messageId,MIN(A.resumedTime),A.suspendedTime,'' FROM
				 (
					 SELECT JobResumed.messageId,JobResumed.timeSource resumedTime,JobSuspended.timeSource suspendedTime
					 FROM @eventsTable JobResumed
					 INNER JOIN @eventsTable JobSuspended
					 ON
						(JobResumed.timeSource>JobSuspended.timeSource) AND
						(
(JobResumed.messageId=(1054 | (CAST(POWER(2, 24) AS BIGINT) * 19)) AND JobSuspended.messageId=(1068 | (CAST(POWER(2, 24) AS BIGINT) * 19)))  OR
(JobResumed.messageId=(1055 | (CAST(POWER(2, 24) AS BIGINT) * 19)) AND JobSuspended.messageId=(318 | (CAST(POWER(2, 24) AS BIGINT) * 19))) OR
(JobResumed.messageId=(1056 | (CAST(POWER(2, 24) AS BIGINT) * 19)) AND JobSuspended.messageId in ((754 | (CAST(POWER(2, 24) AS BIGINT) * 19)),(751 | (CAST(POWER(2, 24) AS BIGINT) * 19)),(747 | (CAST(POWER(2, 24) AS BIGINT) * 19)),(740 | (CAST(POWER(2, 24) AS BIGINT) * 19)),(741 | (CAST(POWER(2, 24) AS BIGINT) * 19))) )
						)
				  )A
				  GROUP BY A.messageId,A.suspendedTime
UPDATE ResultTbl SET message = REPLACE(REPLACE(EvLocaleMsgs.message,'^1%s',dbo.UTCToCellLocalTime(dbo.getdatetime(ResultTbl.suspendedTime),2)),'^2%s',dbo.UTCToCellLocalTime(dbo.getdatetime(ResultTbl.resumedTime),2))
			FROM @suspendedResumedTable  ResultTbl
			INNER JOIN @eventsMap Map ON Map.eventId = ResultTbl.messageId
			INNER JOIN EvLocaleMsgs WITH (NOLOCK) ON EvLocaleMsgs.MessageID = Map.msgId AND LocaleID = @localeId
			IF EXISTS(SELECT 1 FROM @suspendedResumedTable)
			BEGIN
				SELECT @possibleCause+= '<li>' + message + '</li>' FROM @suspendedResumedTable WHERE message IS NOT NULL ORDER BY resumedTime DESC
			END
SELECT @possibleCause+='<li>' + dbo.fn_EvFormatEventMsgText(MAX(eventId), @localeId, messageId, 1, 2) + '</li>' FROM @eventsTable WHERE anomalous > 0 AND severity IN (6,9) GROUP BY messageId
		END
		--2. Check if content is changed/ backup size is increased
		IF(LEN(@possibleCause) = 0)
		BEGIN
			SELECT @lastBackupTime = attrVal FROM App_SubclientProp WITH (NOLOCK) WHERE attrName = 'Last Data Protected Time' AND modified = 0 AND componentNameId = @subclientId
			SELECT TOP(1) @lastBackupSize = totaluncompbytestoxfer FROM JMBkpStats WITH (NOLOCK) WHERE appId = @subclientId AND bkpLevel = @backupLvl AND opType = @opType AND status IN (1,16) ORDER BY servEndDate desc  --CVJobStatus::JMSUCCESS,CVJobStatus::COMMITTED
			IF (@lastBackupTime > 0)
			BEGIN
				IF EXISTS (SELECT 1 FROM APP_ScFilterFile WITH(NOLOCK) WHERE componentNameId = @subclientId AND (created > @lastBackupTime OR modified > @lastBackupTime))
				BEGIN
SELECT @msgString = message FROM EvLocaleMsgs WITH(NOLOCK) WHERE messageId = (1610 | (CAST(POWER(2, 24) AS BIGINT) * 83)) and localeID= @localeId
					SET @possibleCause+= '<li>' + @msgString + '</li>'
				END
				IF (@lastBackupSize > 0)
				BEGIN
					SET @increaseInPercent = 100 * (@backupSize -  @lastBackupSize)/@lastBackupSize
					IF(@increaseInPercent >= 300 AND (@backupSize / (1024*1024*1024) > 0) )  -- alert only if current backup size crosses GB
					BEGIN
SELECT @msgString = message FROM EvLocaleMsgs WITH(NOLOCK) WHERE messageId = (1619 | (CAST(POWER(2, 24) AS BIGINT) * 83)) and localeID = @localeId
						DECLARE @lastbkpStr VARCHAR(16) = ''
						IF @lastBackupSize/(1024*1024*1024)>0
							SET @lastbkpStr = CONVERT(VARCHAR,CONVERT(DECIMAL(10,2), @lastBackupSize/(1024*1024*1024.0))) + ' GB'
						ELSE IF @lastBackupSize/(1024*1024)>0
							SET @lastbkpStr = CONVERT(VARCHAR,CONVERT(DECIMAL(10,2), @lastBackupSize/(1024*1024.0))) + ' MB'
						ELSE IF @lastBackupSize/(1024)>0
							SET @lastbkpStr = CONVERT(VARCHAR,CONVERT(DECIMAL(10,2), @lastBackupSize/(1024.0))) + ' KB'
						ELSE
							SET @lastbkpStr = CONVERT(VARCHAR, @lastBackupSize) + ' BYTES'
						SET @msgString = REPLACE(@msgString,'^1%s', @lastbkpStr)
						SET @msgString = REPLACE(@msgString,'^2%s', CONVERT(VARCHAR,CONVERT(DECIMAL(10,2), @backupSize/(1024*1024*1024.0)))+' GB')
						SET @possibleCause+= '<li>' + @msgString + '</li>'
					END
				END
			END
		END
		--3. check if the previous jobs have failed consecutively
		IF(LEN(@possibleCause) = 0)
		BEGIN
			DECLARE @failedCount INT = (SELECT COUNT(1) FROM JMBkpStats WITH(NOLOCK) WHERE servStartDate > @lastBackupTime AND appId = @subclientId AND opType = @opType AND bkpLevel = @backupLvl AND status <> 9/*CVJobStatus_DROPPED*/)
			IF( @failedCount >= 3)
			BEGIN
SELECT @msgString = message FROM EvLocaleMsgs WITH(NOLOCK) WHERE messageId = (1612 | (CAST(POWER(2, 24) AS BIGINT) * 83)) and localeID= @localeId
				SET @msgString = REPLACE(@msgString,'^1%d',@failedCount)
				SET @possibleCause+= '<li>' + @msgString + '</li>'
			END
		END
		-- if it for report and we have a reason,  surround it by the required tags/template
		IF @forReport = 1 AND LEN(@possibleCause) > 0
		BEGIN
SELECT @msgString = message FROM EvLocaleMsgs WITH(NOLOCK) WHERE messageId = (3829 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeID= @localeId
			SET @possibleCause = REPLACE(@msgString,'^1%s',@possibleCause)
		END
		RETURN @possibleCause
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NTGetPossibleCausesForLongRunTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NTGetPossibleCausesForLongRunTime' AND revision = '1.1.2.7')

  insert into GXDBVersions values(5, 'NTGetPossibleCausesForLongRunTime',  '1.1.2.7', 'NTGetPossibleCausesForLongRunTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
