

--  ------------  Generated from [../../../Source/CommServer/Db/Function/NTGetPlanRecipientsForRule.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: NTGetPlanRecipientsForRule'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTGetPlanRecipientsForRule]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NTGetPlanRecipientsForRule]
  delete from GXDBVersions where name = 'NTGetPlanRecipientsForRule' and type = 5
END
GO

CREATE FUNCTION NTGetPlanRecipientsForRule(@ruleId integer)
RETURNS @userNGroupIds TABLE (userOrGroupId INT, isUser int)
-- WITH ENCRYPTION
AS
BEGIN
-- Refresh the recipient list for alerts attached to plans
declare @planIds table
(
planId int
)
Insert into @planIds
select componentNameId from App_planProp with (READUNCOMMITTED) where attrname = 'Alert' + ' ' + cast(@ruleId as nvarchar(32)) and attrVal != '0'
union
select componentNameId from App_planProp with (READUNCOMMITTED) where attrname = 'Alert' and
@ruleId in (select cast(_ID as int) from dbo.SplitIDString(attrVal))
-- Insert into this list users who are directly associated to all plans
Insert into @userNGroupIds(userOrGroupId,isUser)
select componentNameId,1
from UMUsersProp WITH (READUNCOMMITTED)
inner join @planIds planIds on
planIds.planId = CAST(UMUsersProp.attrVal AS INT)
and UMUsersProp.attrname = 'Associated Plan'
and cast(UMUsersProp.attrVal as int) = planIds.planId
and modified = 0
-- Insert into this list groups who are indirectly associated to all plans via User groups or AD user groups
Insert into @userNGroupIds(userOrGroupId,isUser)
select CAST(App_PlanProp.attrVal AS INT),0
from App_PlanProp WITH (READUNCOMMITTED)
inner join @planIds planIds on
planIds.planId = App_PlanProp.componentNameId
and App_PlanProp.attrName = 'Associated internal user group'
Insert into @userNGroupIds(userOrGroupId,isUser)
select CAST(App_PlanProp.attrVal AS INT),0
from App_PlanProp WITH (READUNCOMMITTED)
inner join @planIds planIds on
planIds.planId = App_PlanProp.componentNameId
and App_PlanProp.attrName = 'Associated external user group'
return
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NTGetPlanRecipientsForRule]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NTGetPlanRecipientsForRule' AND revision = '1.1.2.4')

  insert into GXDBVersions values(5, 'NTGetPlanRecipientsForRule',  '1.1.2.4', 'NTGetPlanRecipientsForRule', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
