

--  ------------  Generated from [../../../Source/CommServer/Db/Function/NTGetDefaultAlertMessage.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: NTGetDefaultAlertMessage'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTGetDefaultAlertMessage]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NTGetDefaultAlertMessage]
  delete from GXDBVersions where name = 'NTGetDefaultAlertMessage' and type = 5
END
GO

CREATE FUNCTION [dbo].[NTGetDefaultAlertMessage](@NotificationID INT, @localeID INT, @isHtml INT)
  RETURNS NVARCHAR(MAX)
AS
BEGIN
DECLARE @attrName NVARCHAR(100) = 'Alert formatted message Html'
IF @isHtml = 0
BEGIN
SET @attrName = 'Alert formatted message Text'
END
-- First check if we have localized message attribute for alert. If so we localize from that
DECLARE @notifPropMessage NVARCHAR(MAX) = ''
SELECT @notifPropMessage = attrVal FROM NTNotificationProp WITH (NOLOCK)
	WHERE NTNotificationProp.ComponentNameId = @NotificationID
	AND NTNotificationProp.attrName = @attrName
IF (@notifPropMessage IS NOT NULL AND LEN(@notifPropMessage)>0)
BEGIN
	DECLARE @notifPropMessageSub NVARCHAR(MAX) = ''
	DECLARE @indexBodyToken INT = 0
SET @indexBodyToken = charindex('$$1241513985$$',@notifPropMessage) -- Subject body token ... ALERT_TOKEN_MESSAGE_BODY
-- First get the subject from the template message since processing token replacement for subject and body is different. For body in case of html, we replace $$messageID$$ with token value escaped
SET @notifPropMessageSub = substring(@notifPropMessage,1,@indexBodyToken+LEN('$$1241513985$$')-1)
SET @notifPropMessage = substring(@notifPropMessage,@indexBodyToken+LEN('$$1241513985$$'),LEN(@notifPropMessage))
SELECT @notifPropMessage =  REPLACE(@notifPropMessage, '$$'+CONVERT(NVARCHAR(15),EvLocaleMsgs.MessageID)+'$$',
		CASE WHEN @isHtml = 1 THEN dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0, @localeId, EvLocaleMsgs.MessageID, 0,2),1)
			ELSE dbo.fn_EvFormatEventMsgText(0, @localeId, EvLocaleMsgs.MessageID, 0,2)
			END
		)
	FROM EvLocaleMsgs WITH (NOLOCK)
	where LocaleID=0 AND SubsystemID=74
AND (@notifPropMessage LIKE '%$$'+CONVERT(NVARCHAR(15),EvLocaleMsgs.MessageID)+'$$%' )
	-- For subject we never escape. We escape only the body
SELECT @notifPropMessageSub =  REPLACE(@notifPropMessageSub, '$$'+CONVERT(NVARCHAR(15),EvLocaleMsgs.MessageID)+'$$',
			dbo.fn_EvFormatEventMsgText(0, @localeId, EvLocaleMsgs.MessageID, 0,2)
		)
	FROM EvLocaleMsgs WITH (NOLOCK)
	where LocaleID=0 AND SubsystemID=74
AND (@notifPropMessageSub LIKE '%$$'+CONVERT(NVARCHAR(15),EvLocaleMsgs.MessageID)+'$$%' )
	RETURN @notifPropMessageSub+@notifPropMessage
END
-- Else we pick up from default localized message from notification template.
DECLARE @notifTemplateMessage NVARCHAR(MAX) = ''
SELECT @notifTemplateMessage = NTNotificationTemplate.defaultFormatString
FROM NTNotificationTemplate WITH (NOLOCK) INNER JOIN NTNotificationRule WITH (NOLOCK) ON
NTNotificationRule.alertTypeID = NTNotificationTemplate.NTAlertTypeId
AND ( (@isHtml = 1 AND NTNotificationTemplate.messageType IN (1,8192) AND messageFormatType=1)
OR (@isHtml = 0 AND NTNotificationTemplate.messageType IN (1,4,8,8192,32768) AND messageFormatType=0)
)
AND NTNotificationTemplate.locale = @localeID
AND NTNotificationRule.ID = @NotificationID
DECLARE @tagstart NVARCHAR(20) = '<MsgTokSep'
DECLARE @tagend NVARCHAR(20) = 'MsgTokSep>'
if(@isHtml=1)
BEGIN
	SET	@tagstart = '&lt;MsgTokSep'
	SET	@tagend =  'MsgTokSep&gt;'
END
IF CHARINDEX(@tagstart,@notifTemplateMessage )=0
BEGIN
	RETURN @notifTemplateMessage
END
DECLARE @beginIndex INT = 1
DECLARE @endIndex INT = 1
DECLARE @secondSpaceIndex INT = 1
WHILE (1>0)
BEGIN
	SET @beginIndex=CHARINDEX(@tagstart,@notifTemplateMessage,@beginIndex)
	IF @beginIndex=0
	BEGIN
		BREAK
	END
	SET @endIndex=CHARINDEX(@tagend,@notifTemplateMessage,@beginIndex)
	IF @endIndex=0
	BEGIN
		BREAK
	END
	SET @secondSpaceIndex = CHARINDEX(' ',@notifTemplateMessage,@beginIndex)
	IF @secondSpaceIndex=0 OR @secondSpaceIndex>@endIndex
	BEGIN
		BREAK
	END
	SET @secondSpaceIndex = CHARINDEX(' ',@notifTemplateMessage,@secondSpaceIndex+1)
	IF @secondSpaceIndex=0 OR @secondSpaceIndex>@endIndex
	BEGIN
		BREAK
	END
	/*
	if( !criteriaSelected )
	{
            paramString = paramString.substr(0,tagStartIndex) + paramString.substr(startOfTagEndIndex+tagend.length()+1);
    }
	else
	{
        paramString = paramString.substr(0,tagStartIndex) +
				        paramString.substr(secondSpaceIndex,startOfTagEndIndex-secondSpaceIndex) +
						paramString.substr(startOfTagEndIndex + tagend.length()+1) ;
    }*/
	DECLARE @messagesubstr NVARCHAR(MAX) = ''
	SET @messagesubstr = SUBSTRING(@notifTemplateMessage, @beginIndex, @endIndex+LEN(@tagend)-@beginIndex)
	-- Check whether msgIndex has criteria selected.
	IF EXISTS(SELECT 1 FROM NTSelCriteria WITH (NOLOCK) WHERE RuleID = @NotificationID
		AND ( @messagesubstr like '% '+CONVERT(NVARCHAR(10), NTSelCriteria.availCriteriaId)+',%' OR
			@messagesubstr like '%,'+CONVERT(NVARCHAR(10), NTSelCriteria.availCriteriaId)+',%' OR
			@messagesubstr like '%,'+CONVERT(NVARCHAR(10), NTSelCriteria.availCriteriaId)+' %' OR
			@messagesubstr like '% '+CONVERT(NVARCHAR(10), NTSelCriteria.availCriteriaId)+' %') )
		BEGIN
			SET @notifTemplateMessage = SUBSTRING(@notifTemplateMessage,1, @beginIndex-1)+
				SUBSTRING(@notifTemplateMessage,@secondSpaceIndex , @endIndex - @secondSpaceIndex-1)+
				SUBSTRING(@notifTemplateMessage,@endIndex+len(@tagend), LEN(@notifTemplateMessage) )
		END
		ELSE
		BEGIN
			SET @notifTemplateMessage = SUBSTRING(@notifTemplateMessage,1, @beginIndex-1)+
				SUBSTRING(@notifTemplateMessage,@endIndex+len(@tagend), LEN(@notifTemplateMessage) )
		END
END
RETURN @notifTemplateMessage
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NTGetDefaultAlertMessage]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NTGetDefaultAlertMessage' AND revision = '')

  insert into GXDBVersions values(5, 'NTGetDefaultAlertMessage',  '', 'NTGetDefaultAlertMessage', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
