

--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2Func_NumExtRetJobsOnMedia.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2Func_NumExtRetJobsOnMedia'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2Func_NumExtRetJobsOnMedia]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2Func_NumExtRetJobsOnMedia]
  delete from GXDBVersions where name = 'MMS2Func_NumExtRetJobsOnMedia' and type = 5
END
GO

	CREATE FUNCTION MMS2Func_NumExtRetJobsOnMedia(@inMediaId 	integer)
	RETURNS integer
	AS
	BEGIN
		DECLARE @numJob 	integer

		declare @tblChunkList table (archChunkId bigint, commCellId int)
		declare @tblArchFileCopyList table (archfileId int, commCellId int, copyId int)
		declare @tblJobCopyList table (jobId int, commCellId int, copyId int, fileType int)
		declare @tblExtendedJobCopy table (jobId int, commCellId int, retentionFlags int)

		insert into @tblChunkList
		select id, commCellId
		from archChunk
		where volumeId in (select volumeId from MMVolume where mediaId = @inMediaId)

		insert into @tblArchFileCopyList
		select distinct a.archFileId, a.commCellId, a.archCopyId
		from archChunkMapping a, @tblChunkList b
		where a.archChunkId = b.archChunkId
		and a.chunkCommCellId = b.commCellId

		insert into @tblJobCopyList
		select distinct a.jobId, a.commCellId, b.copyId, a.fileType
		from archFile a, @tblArchFileCopyList b
		where a.id = b.archFileId
		and a.commCellId = b.commCellId

		insert into @tblExtendedJobCopy
		select distinct a.jobid, a.commcellId, a.retentionFlags
		from JMJobDataStats a, @tblJobCopyList b
		where a.jobId = b.jobId
		and a.commCellId = b.commCellId
		and a.archGrpCopyId = b.copyId
		and a.dataType = b.filetype
		and a.disabled & 256 = 0
		and a.status <> 1000
		and (a.retentionFlags > 0 or a.manualRetentionEndTime <> 0)

		set @numJob = @@rowCount
		RETURN @numJob

     END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2Func_NumExtRetJobsOnMedia]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2Func_NumExtRetJobsOnMedia' AND revision = '1.6.208.1')

  insert into GXDBVersions values(5, 'MMS2Func_NumExtRetJobsOnMedia',  '1.6.208.1', 'MMS2Func_NumExtRetJobsOnMedia', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
