

--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2Func_GetLANFreeDataPaths.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2Func_GetLANFreeDataPaths'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2Func_GetLANFreeDataPaths]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2Func_GetLANFreeDataPaths]
  delete from GXDBVersions where name = 'MMS2Func_GetLANFreeDataPaths' and type = 5
END
GO

	CREATE FUNCTION MMS2Func_GetLANFreeDataPaths(	@i_copyId	integer,
                                                    @i_clientId	integer,
                                                    @i_appId 	integer,
                                                    @i_use_SC_DPs	integer,
																										@i_dataType	integer )
	RETURNS @MMS2Func_GetLANFreeDataPaths  table (DataPathId Integer, isVirtual Integer)
	AS
	BEGIN
		DECLARE @isIndexing	integer
		SET @isIndexing = dbo.IsIndexingApp(@i_AppId)
		DECLARE @l_tmpClientIds TABLE (clientId Integer, isVirtual Integer)
		DECLARE @l_physicalClientId Integer
 		SET @l_physicalClientId = ISNULL(
 				(	SELECT attrVal from APP_ClientProp where attrName = N'Active Physical Node' and modified = 0 and componentnameId = @i_clientId )
 				, @i_clientId )
		IF (@l_physicalClientId <> @i_clientId)
		BEGIN
			INSERT INTO @l_tmpClientIds VALUES (@i_clientId, 1)
		END
		INSERT INTO @l_tmpClientIds VALUES (@l_physicalClientId, 0)
		DECLARE @l_tmpDatapathInfo TABLE (DataPathId Integer, drivePoolId Integer, drivePoolType Integer, Flag Integer, MAClientId Integer, HostClientId Integer, isSCDataPath Integer)
		INSERT INTO @l_tmpDatapathInfo
		SELECT DPath.DataPathId, DPath.DrivePoolId, DP.DrivePoolType, DPath.Flag, DP.ClientId, DPath.HostClientId, 0
		FROM MMDataPath AS DPath, MMDrivePool AS DP
		WHERE DPath.CopyId = @i_copyId AND DP.DrivePoolId = DPath.DrivePoolId
    IF (@i_use_SC_DPs = 1)
		BEGIN
			DELETE FROM @l_tmpDatapathInfo
			WHERE DataPathId NOT IN
			(
						Select DataPathId
						from APP_AppToDataPath
						where componentNameId = @i_AppId AND
						dataType = @i_dataType
			)
		END
		DELETE FROM @l_tmpDatapathInfo
		WHERE (Flag & 4) = 0
		DECLARE @l_tmpOfflineMATbl TABLE (MAClientId Integer)
		INSERT INTO @l_tmpOfflineMATbl
		SELECT DISTINCT MAClientId
		FROM @l_tmpDatapathInfo
		DELETE @l_tmpOfflineMATbl
		FROM @l_tmpOfflineMATbl AS tmpOfflTbl, IdxAccessPath AS IAP, IdxCache AS IC, MMHost as MH
		WHERE
			MH.ClientId = tmpOfflTbl.MAClientId AND MH.MmHostSoftState = 1 AND
		  	IAP.ClientId = tmpOfflTbl.MAClientId AND IC.IdxCacheId = IAP.IdxCacheId AND
			(	@isIndexing = 0 OR
					(
     					IC.Enabled = 1 AND IAP.Enabled = 1 AND IC.Softstate = 1 AND IAP.Softstate = 1 AND IC.IdxCacheType = 1
					)
			)
     DELETE FROM @l_tmpDatapathInfo
     FROM @l_tmpDatapathInfo AS tmpDP, @l_tmpOfflineMATbl AS tmpOfflTbl
     WHERE tmpDP.MAClientId = tmpOfflTbl.MAClientId
		INSERT INTO @MMS2Func_GetLANFreeDataPaths
		SELECT distinct tmpDP.DataPathId, TCLIDs.isVirtual
		FROM  @l_tmpDatapathInfo AS tmpDP, @l_tmpClientIds as TCLIDs
		WHERE tmpDP.HostClientId = TCLIDs.clientId
		RETURN
 	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2Func_GetLANFreeDataPaths]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2Func_GetLANFreeDataPaths' AND revision = '1.7')

  insert into GXDBVersions values(5, 'MMS2Func_GetLANFreeDataPaths',  '1.7', 'MMS2Func_GetLANFreeDataPaths', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
