

--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2FUNC_IsMountPathHasSpaceRequired.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2FUNC_IsMountPathHasSpaceRequired'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2FUNC_IsMountPathHasSpaceRequired]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2FUNC_IsMountPathHasSpaceRequired]
  delete from GXDBVersions where name = 'MMS2FUNC_IsMountPathHasSpaceRequired' and type = 5
END
GO

	CREATE FUNCTION MMS2FUNC_IsMountPathHasSpaceRequired( @i_mountPathId int, @i_mediaId int )
		RETURNS int
		AS
		BEGIN
			DECLARE @numCurReservs     	int = 0
			DECLARE @maxToWriteMP     	int = 0
			DECLARE @reserveSpace     	int = 0
			DECLARE @mediaSideId     	int = 0
			DECLARE @libraryId	     	int = 0
			--
			-- Skip space check for Metallic storage, it's covered as part of license check
			-- In case of license server model, multiple CommCells shares capacity so mount path level capacity and freespace may not be accurate.
			-- Only license tables contains consolidated capacity and usage from all CommCells.
			--
			IF EXISTS
			(
				SELECT 1
				FROM 	MMMetallicStorage MS WITH(READUNCOMMITTED)
				WHERE	MS.MountPathId = @i_mountPathId
			)
			BEGIN
				RETURN 0
			END
			select @maxToWriteMP = MaxDataToWriteMB, @reserveSpace = MagneticSpaceRsrvInMB, @mediaSideId = MediaSideId, @libraryId = LibraryId
			from MMMountPath with (readuncommitted) where MountPathId = @i_mountPathId
						if exists(select 1 from MMLibrary with(readuncommitted) where LibraryId = @libraryId
and (ExtendedAttributes & (67108864 | 134217728)) = (67108864 | 134217728))
						begin
RETURN  20174
						end
			if @maxToWriteMP > 0
			begin
				select 	@numCurReservs = COUNT(ReservationId)
				from    MMResource WITH (READUNCOMMITTED)
				where   HasJobInterrupted = 0
						and (ReservationType & 2) = 2
						and MediaId = @i_mediaId
				if (((dbo.MMS2FUNC_GetMediaValidData(@i_mediaId) /(1024 * 1024)) + (4096 * (@numCurReservs + 1))) > @maxToWriteMP)
				begin
					RETURN 20010
				end
			end
			else if @reserveSpace > 0
			begin
				DECLARE @minFreeSpaceMB int = ISNULL((SELECT value FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'RM_CONFIG_MIN_MP_FREE_SPACE_OVER_RESERVE_LIMIT'), 1024)
				if EXISTS(SELECT 1 FROM MMMediaSide WITH (READUNCOMMITTED) WHERE MediaSideId = @mediaSideId
							AND FreeBytesMB < (@reserveSpace + @minFreeSpaceMB))
				begin
					RETURN 20011
				end
			end
			RETURN 	0
		END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2FUNC_IsMountPathHasSpaceRequired]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2FUNC_IsMountPathHasSpaceRequired' AND revision = '1.1.4.6')

  insert into GXDBVersions values(5, 'MMS2FUNC_IsMountPathHasSpaceRequired',  '1.1.4.6', 'MMS2FUNC_IsMountPathHasSpaceRequired', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
