

--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2FUNC_GetSharedMountPath.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2FUNC_GetSharedMountPath'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2FUNC_GetSharedMountPath]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2FUNC_GetSharedMountPath]
  delete from GXDBVersions where name = 'MMS2FUNC_GetSharedMountPath' and type = 5
END
GO

 			create function MMS2FUNC_GetSharedMountPath (@deviceId Integer, @onlyPath BIT)
			returns varchar(1024)
			as
			begin

				declare @mountPath Varchar(1024)
				set @mountPath = ''
				SELECT TOP 1 @mountPath =
						CASE WHEN @onlyPath = 0
							THEN (CASE WHEN MMDC1.deviceAccessType & 16 = 16 /* DATASERVER_IP_DEVICEACCESS */ THEN N'IP | ' WHEN MMDC1.deviceAccessType & 32 = 32 /* DATASERVER_SAN_DEVICEACCESS */ THEN N'FC | ' WHEN MMDC1.deviceAccessType & 128 = 128 /* DATASERVER_ISCSI_DEVICEACCESS */ THEN N'ISCSI | ' ELSE N' | ' END)
									   + MMDCPrimary.Folder + ' | ' +  C.name
							ELSE
								MMDCPrimary.Folder
						END
				FROM MMDeviceController MMDC1
				INNER JOIN  MMDeviceController MMDCPrimary ON MMDC1.DeviceId = MMDCPrimary.DeviceId
				INNER JOIN  APP_Client C ON MMDCPrimary.ClientId = C.id
				WHERE (MMDC1.DeviceAccessType & 16 > 0 --16 = DATASERVER_IP_DEVICEACCESS
						OR MMDC1.DeviceAccessType & 32 > 0 --32 = DATASERVER_SAN_DEVICEACCESS
						OR MMDC1.DeviceAccessType & 128 > 0) --128 = DATASERVER_ISCSI_DEVICEACCESS
					  AND MMDCPrimary.DeviceAccessType & 8 > 0 --8 = PREFERRED_DEVICEACCESS
						AND C.id <> MMDC1.ClientId AND MMDC1.DeviceId = @deviceId
				RETURN @mountPath

			end



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2FUNC_GetSharedMountPath]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2FUNC_GetSharedMountPath' AND revision = '1.3')

  insert into GXDBVersions values(5, 'MMS2FUNC_GetSharedMountPath',  '1.3', 'MMS2FUNC_GetSharedMountPath', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
