

--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2FUNC_GetReadStreamCountForMA.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2FUNC_GetReadStreamCountForMA'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2FUNC_GetReadStreamCountForMA]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2FUNC_GetReadStreamCountForMA]
  delete from GXDBVersions where name = 'MMS2FUNC_GetReadStreamCountForMA' and type = 5
END
GO

	CREATE FUNCTION MMS2FUNC_GetReadStreamCountForMA(@i_clientId integer, @i_notReserved bit)
	RETURNS integer
	AS
	BEGIN
	DECLARE	@l_DiskReadStreamCount	INTEGER = 0
	--JMRegisteredPipelines contains all active pipelines for a job
	--Here machineName will the one who sent request to JM for pipeline registration
	--For old pipeline both tail and head registers with JM and pipelineId will be in the format <tailClientHostName_*****>
	--For SDT pipeline only head registers with JM and pipelineId will be in the format <SDTPipe_tailClientName_headClientName_*****>
	--For Aux and MediaRefresh  tail is the reader MA
	--For restores head is the reader MA
	SELECT	@l_DiskReadStreamCount = count(*)
	FROM	JMRegisteredPipelines P WITH (READUNCOMMITTED), JMJobInfo J WITH (READUNCOMMITTED), APP_Client C WITH(READUNCOMMITTED)
	WHERE	P.jobId = J.jobId AND P.toBeStopped = 0 AND C.id = @i_clientId
			AND
			(
				(
					J.opType IN (13 /*AUXCOPY*/, 74 /*MEDIAREFRESHING*/, 104 /*AUXCOPY2*/)
					AND
					(
						(P.pipelinetype = 0 /*oldPipe*/ AND P.machineName = C.name AND P.pipelineId like C.name +'%')
						OR
						(P.pipelinetype = 1 /*SDTPipe*/ AND P.pipelineId like 'SDTPipe_' + C.name + '_' + P.machineName + '%')
					)
				)
				OR
				(
					J.opType IN (5 /*RESTORE*/, 12 /*INDEXRESTORE*/, 14 /*SYNTHFULL*/, 31 /*ARCHIVECHECK*/, 40 /*INDEXFREERESTORE*/, 48 /*SRSYSTEMRECOVERY*/,
									49 /*SEARCHANDRETRIEVE*/,53 /*OFFLINECONTENTINDEX*/, 54 /*POWERRESTORE*/, 55 /*POWERSEARCHANDRETRIEVE*/, 57 /*ONLINECONTENTINDEX*/,
									80 /*DEDUPDBSYNC */, 82 /*DATA_VERIFICATION*/, 102 /*ARCHIVERESTORE*/)   -- 106 ARCHIVECHECK2 is subOpType
					AND
					(
						(P.pipelinetype = 0 /*oldPipe*/ AND P.machineName = C.name AND P.pipelineId like C.name +'%')
						OR
						(P.pipelinetype = 1 /*SDTPipe*/ AND P.machineName = C.name)
					)
				)
			)
			AND
			(
				@i_notReserved = 0
				OR
				NOT EXISTS(SELECT 1 FROM MMResourceToJob WITH(READUNCOMMITTED) WHERE JobId_l = P.jobId AND ReservationType = 1 /*RM_RESERVE_TYPE_READ*/)
			)
	RETURN @l_DiskReadStreamCount
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2FUNC_GetReadStreamCountForMA]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2FUNC_GetReadStreamCountForMA' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'MMS2FUNC_GetReadStreamCountForMA',  '1.1.2.2', 'MMS2FUNC_GetReadStreamCountForMA', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
