

--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2FUNC_GetJobsForDrive.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2FUNC_GetJobsForDrive'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2FUNC_GetJobsForDrive]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2FUNC_GetJobsForDrive]
  delete from GXDBVersions where name = 'MMS2FUNC_GetJobsForDrive' and type = 5
END
GO

 			create function MMS2FUNC_GetJobsForDrive (@driveId Integer)
			returns varchar(1024)
			as
			begin

				if (@driveId <= 0) return ''

				declare @l_jobList Varchar(1024)
				set @l_jobList = ''

				SELECT @l_jobList = CASE
										WHEN jobId_l is not null then @l_jobList + cast (jobId_l as varchar(11)) + ', '
										ELSE 'Dangling resource, '
									END

				FROM MMResource R LEFT OUTER JOIN MMResourceToJob MRJ ON MRJ.ReservationId = R.ReservationId
				INNER JOIN MMDrive D ON R.DriveId = D.DriveId
				WHERE D.DriveTypeId <> 10001 AND  D.DriveId > 0 And d.driveId = @driveId

				RETURN case when @l_jobList <> '' then Substring(@l_jobList, 1, len(@l_jobList) - 1) else '' end

			end



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2FUNC_GetJobsForDrive]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2FUNC_GetJobsForDrive' AND revision = '1.2')

  insert into GXDBVersions values(5, 'MMS2FUNC_GetJobsForDrive',  '1.2', 'MMS2FUNC_GetJobsForDrive', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
