

--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2FUNC_GetGUIMediaAttributeString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2FUNC_GetGUIMediaAttributeString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2FUNC_GetGUIMediaAttributeString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2FUNC_GetGUIMediaAttributeString]
  delete from GXDBVersions where name = 'MMS2FUNC_GetGUIMediaAttributeString' and type = 5
END
GO

 			CREATE FUNCTION MMS2FUNC_GetGUIMediaAttributeString(@GAttr Integer)
 			RETURNS varchar(1024)
 			AS
 			BEGIN

 				IF (@GAttr = 0) RETURN ''

 				DECLARE @GAttrString  VARCHAR(1024)

 				-- MMS2_MULTIPLESIDED_MEDIA				16
 				-- MMS2_MAGNETIC_MEDIA						8
 				-- MMS2_RSM_MEDIA							1024


 				SET @GAttrString  = CASE	WHEN (@GAttr  & 8) > 0 THEN 'Mountpath, '
 											WHEN (@GAttr  & 16) > 0 THEN 'Optical Media, '
 											WHEN (@GAttr  & 1024) > 0 THEN 'RSM Media, '
 											WHEN (@GAttr  <> 0) THEN 'Tape Media, '
 											ELSE ', ' END

 				-- MMS2_STANDALONE_MEDIA					4
 				IF 	(@GAttr  & 4) > 0 	SET @GAttrString = @GAttrString  + 'Standalone, '

 				-- MMS2_DUPLICATE_MEDIA					131072
 				IF 	(@GAttr  & 131072) > 0	SET @GAttrString = @GAttrString  + 'Duplicate Barcode, '

 				-- MMS2_INVALID_BARCODE_MEDIA				1048576
 				IF 	(@GAttr  & 1048576) >0 	SET @GAttrString = @GAttrString  + 'Invalid Barcode, '

 				-- MMS2_NONGALAXY_MEDIA					524288
 				IF 	(@GAttr  & 524288) >0 	SET @GAttrString = @GAttrString  + 'Non Galaxy Media, '

 				-- MMS2_CLEANING_MEDIA					512
 				IF 	(@GAttr  & 512) > 0	SET @GAttrString = @GAttrString  + 'Cleaning Media, '

 				-- MMS2_ASSIGNED_MEDIA						1
 				IF 	(@GAttr  & 1) >0	SET @GAttrString = @GAttrString  + 'Assigned, '

 				-- MMS2_BAD_MEDIA							32
 				IF 	(@GAttr  & 32) >0 	SET @GAttrString = @GAttrString  + 'Bad, '
 				-- if tape (not optical)
 				-- MMS2_MEDIA_SIDEA_BAD					2048
 				-- MMS2_BAD_MEDIA							32
 				-- MMS2_MULTIPLESIDED_MEDIA				16
 				IF (@GAttr & (2048 | 32 | 16)) = 2048 SET @GAttrString = @GAttrString  + 'Bad, '

 				-- MMS2_DEPRECATED_MEDIA					64
 				IF 	(@GAttr  & 64) > 0	SET @GAttrString = @GAttrString  + 'Deprecated, '

 				-- MMS2_EXPORTED_MEDIA						2
 				IF 	(@GAttr  & 2) >0  	SET @GAttrString = @GAttrString  + 'Exported, '

 				-- MMS2_MEDIA_IN_WRONG_LIB					262144
 				IF 	(@GAttr  & 262144) >0  	SET @GAttrString = @GAttrString  + 'Wrong Library, '

 				-- 16777216 = MMS2_PINNED
 				IF 	(@GAttr  & 16777216) >0 	SET @GAttrString = @GAttrString  + 'Pinned, '

 				-- 8388608 = MMS2_AGED_MEDIA
 				IF 	(@GAttr  & 8388608) >0 SET @GAttrString = @GAttrString  + 'Aged, '

 				-- MMS2_MEDIA_SIDEA_ACTIVE					128
 				IF 	(@GAttr  & (128|8)) =128 	SET @GAttrString = @GAttrString  +
 							( CASE WHEN (@GAttr  & (16| 8)) = 16 THEN 'Side A ' ELSE '' END ) + 'Active, '

 				-- MMS2_MEDIA_SIDEA_FULL					256
 				IF 	(@GAttr  & (256|8)) = 256 	SET @GAttrString = @GAttrString  +
 							( CASE WHEN (@GAttr  & (16| 8)) = 16 THEN 'Side A ' ELSE '' END ) + 'Full, '

 				-- MMS2_MEDIA_SIDEA_BAD					2048
 				-- MMS2_MULTIPLESIDED_MEDIA				16
 				IF 	(@GAttr  & (2048 | 16 | 8) = (2048|16))	SET @GAttrString = @GAttrString  + 'Side A Bad, '

 				-- MMS2_MEDIA_SIDEA_RDONLY					4096
 				IF 	(@GAttr  & (4096 | 8)) = 4096 	SET @GAttrString = @GAttrString  +
 							( CASE WHEN (@GAttr  & (16| 8)) = 16 THEN 'Side A ' ELSE '' END ) + 'Read Only, '

 				-- MMS2_MEDIA_SIDEA_PARTIALLY_FULL			2097152
 				IF 	(@GAttr  & (2097152|8)) = 2097152 	SET @GAttrString = @GAttrString  +
 							( CASE WHEN (@GAttr  & (16| 8)) = 16 THEN 'Side A ' ELSE '' END ) + 'Appendable, '

 				-- MMS2_MEDIA_SIDEB_ACTIVE					8192
 				IF 	(@GAttr  & ( 8192 | 8)) = 8192 	SET @GAttrString = @GAttrString  + 'Side B Active, '

 				-- MMS2_MEDIA_SIDEB_FULL					16384
 				IF 	(@GAttr  & (16384|8)) =16384 	SET @GAttrString = @GAttrString  + 'Side B Full, '

 				-- MMS2_MEDIA_SIDEB_BAD					32768
 				IF 	(@GAttr  & 32768|8) = 32768 	SET @GAttrString = @GAttrString  + 'Side B Bad, '

 				-- MMS2_MEDIA_SIDEB_RDONLY					65536
 				IF 	(@GAttr  & (65536|8)) = 65536 	SET @GAttrString = @GAttrString  + 'Side B Read Only, '

 				-- MMS2_MEDIA_SIDEB_PARTIALLY_FULL			4194304
 				IF (@GAttr  & (4194304|8)) = 4194304	SET @GAttrString = @GAttrString  + 'Side B Read Appendable, '

 				RETURN case when @GAttrString <> '' then Substring(@GAttrString, 1, len(@GAttrString) - 1) else '' end

 			END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2FUNC_GetGUIMediaAttributeString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2FUNC_GetGUIMediaAttributeString' AND revision = '1.2')

  insert into GXDBVersions values(5, 'MMS2FUNC_GetGUIMediaAttributeString',  '1.2', 'MMS2FUNC_GetGUIMediaAttributeString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
