

--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2FUNC_GetGuiMediaAttribute.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2FUNC_GetGuiMediaAttribute'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2FUNC_GetGuiMediaAttribute]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2FUNC_GetGuiMediaAttribute]
  delete from GXDBVersions where name = 'MMS2FUNC_GetGuiMediaAttribute' and type = 5
END
GO

	CREATE FUNCTION MMS2FUNC_GetGuiMediaAttribute(@i_MediaId int)
	RETURNS INTEGER
	-- WITH ENCRYPTION
	AS
	BEGIN

  IF (@i_MediaId = 0) RETURN 0
	declare @l_MediaAttributes INTEGER
	declare @l_IsAged INTEGER
	declare @l_IsInMediaGroup INTEGER
	declare @l_isMagBit INTEGER
	declare @l_isMediaExportedBit INTEGER
	declare @l_MediaFlagsBit	INTEGER
	declare @l_isRSMBit	INTEGER
	declare @l_LibraryTypeId INTEGER
	declare @l_isCleaningMediaBit INTEGER
	declare @l_VolCount	INTEGER
	declare @l_libraryTypeBits INTEGER
	declare @l_isWrongLibraryBit INTEGER
 	declare @l_mediaStatus	INTEGER
	declare @l_isDuplicateBit INTEGER
	declare @l_isUnrecogBarCode INTEGER
	SELECT
		@l_MediaAttributes = M.attributes,
		@l_IsAged = M.IsAged,
		@l_IsInMediaGroup = M.IsInMediaGroup,
		@l_isWrongLibraryBit = CASE WHEN (M.MediaLocation IN (1,2)  AND (M.LibraryId > 0) AND (M.LastWriteLibraryId > 0) AND (M.LibraryId <> M.LastWriteLibraryId)) THEN 262144 ELSE 0 END,
		@l_isMagBit = CASE WHEN M.mediaTypeId = 10001 THEN 8 ELSE 0 END,
		@l_isMediaExportedBit = CASE WHEN M.mediaLocation = 3 THEN 2 ELSE 0 END,
		@l_MediaFlagsBit = CASE WHEN M.MediaFlags = 2 THEN 32 WHEN M.MediaFlags = 3 THEN 64 ELSE 0 END,
		@l_isRSMBit = CASE WHEN M.ExternalGUID <> '' then 1024 ELSE 0 END,
		@l_LibraryTypeId = isnull(L.LibraryTypeId, 0),
		@l_isCleaningMediaBit = CASE WHEN isnull(MT.IsCleaningMedia, 0) = 1 THEN 512 ELSE 0 END
	FROM MMMedia AS M with (nolock)
		LEFT OUTER JOIN MMLibrary AS L with (nolock) ON (M.LibraryId > 0 AND M.LibraryId = L.LibraryId)
		LEFT OUTER JOIN MMMediaType AS MT with (nolock) ON M.MediaTypeId = MT.MediaTypeId
	WHERE M.MediaId = @i_MediaId
	SET @l_mediaStatus  = ISNULL((  SELECT TOP 1 mediaStatus from MMSlot where mediaid = @i_MediaId ), 0)
  SET @l_isDuplicateBit = (CASE WHEN (@l_mediaStatus & 1) <> 0 THEN 131072 ELSE 0 END)
  IF (@l_mediaStatus & 4) <> 0
  BEGIN
  	SET @l_isWrongLibraryBit = 262144
  	SET @l_isMediaExportedBit = 0
  END
  SET @l_isUnrecogBarCode = CASE WHEN 	(@l_mediaStatus & 2) > 0 THEN 1048576 ELSE 0 END
	SET  @l_libraryTypeBits = CASE 	WHEN @l_LibraryTypeId = 3 THEN 8
					WHEN @l_LibraryTypeId IN (4,5) THEN 4
					ELSE 0 END
 IF (@l_LibraryTypeId = 8) AND (@l_isWrongLibraryBit  > 0)
 BEGIN
 		SET @l_isWrongLibraryBit = 0
 END
	declare @o_MediaAttributeForGUI INTEGER
	SET @o_MediaAttributeForGUI  = 	@l_MediaFlagsBit | @l_isMediaExportedBit | @l_isWrongLibraryBit |
					@l_isRSMBit | @l_isCleaningMediaBit | @l_isMagBit | @l_libraryTypeBits  | @l_isDuplicateBit  | @l_isUnrecogBarCode |
					(@l_MediaAttributes & 16777216) | (@l_MediaAttributes & 536870912)
	IF @l_IsAged > 0
	BEGIN
	  SET @o_MediaAttributeForGUI = @o_MediaAttributeForGUI | 8388608
	END
	IF @l_IsInMediaGroup > 0
	BEGIN
	  SET @o_MediaAttributeForGUI = @o_MediaAttributeForGUI | 1
	END
	IF @l_isMagBit = 0 --This is not required for disk media. Processing large number of volumes for disk mount path here causes unnecessary slow down.
	BEGIN
	declare @l_Volumes TABLE (VolumeId INTEGER, VolumeFlags INTEGER, Attributes INTEGER)
	insert into @l_Volumes
	select volumeId, VolumeFlags, Attributes from MMVolume with (nolock) WHERE MediaId = @i_MediaId
	SET @l_VolCount = @@ROWCOUNT
	DECLARE @l_MediaRefreshBit INTEGER
	SELECT	TOP 1 @l_MediaRefreshBit =
			CASE
				WHEN (Attributes & 16) > 0 THEN 1073741824
				WHEN (Attributes &  8) > 0 THEN 1024
				ELSE 0
			END
	FROM @l_Volumes
	DECLARE @l_SideAVolID INTEGER
	DECLARE @l_SideABit INTEGER
	DECLARE @l_SideBBit INTEGER
	SET @l_SideABit  = 0
	SET @l_SideBBit  = 0
	IF (@l_VolCount > 0)
	BEGIN
		SELECT TOP 1 	@l_SideAVolID = VolumeId,
			     	@l_SideABit =
				CASE
					WHEN VolumeFlags IN (1, 8) THEN 128
					WHEN VolumeFlags = 2 THEN 256
					WHEN VolumeFlags = 3 THEN 4096
					WHEN VolumeFlags = 4 THEN 2048
					WHEN VolumeFlags = 7 THEN 2097152
					ELSE 0
				END
		FROM @l_Volumes
		DELETE FROM @l_Volumes
		WHERE VolumeId = @l_SideAVolID
	END
	IF (@l_VolCount > 1)
	BEGIN
		  SET @o_MediaAttributeForGUI = @o_MediaAttributeForGUI | 16
		SELECT TOP 1 	@l_SideBBit =
				CASE
					WHEN VolumeFlags IN (1, 8) THEN 8192
					WHEN VolumeFlags = 2 THEN 16384
					WHEN VolumeFlags = 3 THEN 65536
					WHEN VolumeFlags = 4 THEN 32768
					WHEN VolumeFlags = 7 THEN 4194304
					ELSE 0
				END
		FROM @l_Volumes
	END
	SET @o_MediaAttributeForGUI = @o_MediaAttributeForGUI |  @l_SideABit | @l_SideBBit | @l_MediaRefreshBit
	END
		RETURN @o_MediaAttributeForGUI
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2FUNC_GetGuiMediaAttribute]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2FUNC_GetGuiMediaAttribute' AND revision = '1.13.2.2')

  insert into GXDBVersions values(5, 'MMS2FUNC_GetGuiMediaAttribute',  '1.13.2.2', 'MMS2FUNC_GetGuiMediaAttribute', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
