

--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2FUNC_DecodeRetentionFlag.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2FUNC_DecodeRetentionFlag'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2FUNC_DecodeRetentionFlag]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2FUNC_DecodeRetentionFlag]
  delete from GXDBVersions where name = 'MMS2FUNC_DecodeRetentionFlag' and type = 5
END
GO

	CREATE FUNCTION MMS2FUNC_DecodeRetentionFlag (@i_CopyId Integer, @i_RetentionFlag Integer)
	RETURNS varchar(1024)
	AS
	BEGIN

		IF (@i_copyId = 0 OR @i_copyId is null OR @i_retentionFlag is null) RETURN ''


		IF (@i_RetentionFlag = 0)
		BEGIN

			DECLARE @l_basicRetDays INTEGER

			SELECT TOP 1  @l_basicRetDays = retentiondays
			FROM archagingrule
			WHERE copyid = @i_copyId

			IF (@l_basicRetDays is null) return ''

			RETURN 'Basic Retention (' +
					(	case when @l_basicRetDays < 0 then 'Infinite)'
						else cast (@l_basicRetDays as varchar(11)) + ' days)'
						end
					)
		END

		DECLARE @l_RetentionFlags VARCHAR(1024)
		SET @l_RetentionFlags = ''

		select @l_RetentionFlags = @l_RetentionFlags +
			case when (@i_retentionFlag & retentionRule) > 1 then
			(
				(	case retentionRule
						WHEN 2 then 'All '
						WHEN 4 then 'Weekly '
						WHEN 8 then 'Monthly '
						WHEN 16 then 'Quarterly '
						WHEN 32 then 'Semi annual '
						WHEN 64 then 'Annual '
						else ''
					end
				) + ' (' +
				(
					case when retentiondays > 0 then cast (retentiondays as varchar(11)) + ') days'
					else 'infinite)'
					end
				)
			) else '' end
			+ ', '
		from archagingruleextended
		where copyid = @i_copyid
		order by retentionrule desc

		RETURN case when @l_RetentionFlags <> '' then substring(@l_RetentionFlags,1,len(@l_RetentionFlags)-1) else '' end

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2FUNC_DecodeRetentionFlag]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2FUNC_DecodeRetentionFlag' AND revision = '1.2')

  insert into GXDBVersions values(5, 'MMS2FUNC_DecodeRetentionFlag',  '1.2', 'MMS2FUNC_DecodeRetentionFlag', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
