

--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2FUNC_CheckForPruningOpWindowOnMA.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2FUNC_CheckForPruningOpWindowOnMA'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2FUNC_CheckForPruningOpWindowOnMA]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2FUNC_CheckForPruningOpWindowOnMA]
  delete from GXDBVersions where name = 'MMS2FUNC_CheckForPruningOpWindowOnMA' and type = 5
END
GO

 			create function MMS2FUNC_CheckForPruningOpWindowOnMA (@hostID integer)
			returns bit
			as
			begin

				declare @clientTimeMidNight dateTime = CAST (CAST (dbo.UTCToClientLocalTime(GETUTCDATE(),@hostID) as date) as datetime)
				declare @clientTimeZoned dateTime = dbo.ClientLocalToUTCTime(@clientTimeMidnight, @hostID)
				declare @unixTimeOnClient integer = dbo.getUnixTime(@clientTimeZoned)
				declare @clientTime datetime = dbo.UTCToClientLocalTime(GETUTCDATE(),@hostID)
				declare @currentTime integer = ( (datepart(hh,@clientTime) + CAST(datepart(mi,@clientTime) as FLOAT)/CAST(60 AS FLOAT) + CAST(datepart(ss,@clientTime) AS FLOAT)/CAST(3600 AS FLOAT))*3600)
				declare @dayOnClient integer = ( power(2, DATEPART (dw, @clientTime) - 1) )
				declare @tmpOperationTbl table (hostId integer, startDate integer, endDate integer, daysOfWeek integer, startTime integer, endTime integer)

				insert into @tmpOperationTbl
				select clientId, startDate, endDate, daysOfWeek, startTime, endTime
				from APP_OpWindowRule where clientId = @hostID and opType = 131072 -- add optype in the where clause later

				if( (select count (*) from @tmpOperationTbl) = 0)
				begin
					return 0
				end
				else
				begin

					IF EXISTS(
					select * from @tmpOperationTbl t
					where (startdate <> 0 and enddate <> 0  and @unixTimeOnClient between startDate and (endDate+ 86499))
					AND (t.daysOfWeek & @dayOnClient) > 0
					AND @currentTime between startTime and endTime

								UNION

					SELECT * from @tmpOperationTbl t
					WHERE (startDate = 0 and endDate<>0 and @unixTimeOnClient <= (endDate+ 86499) )
					AND (t.daysOfWeek & @dayOnClient) > 0
					AND @currentTime between startTime and endTime

								UNION
					SELECT * from @tmpOperationTbl t
					WHERE (startDate = 0 and endDate = 0)
					AND (t.daysOfWeek & @dayOnClient) > 0
					AND @currentTime between startTime and endTime

								UNION
					SELECT * from @tmpOperationTbl t
					WHERE (startDate <> 0 and endDate = 0 and startDate <= @unixTimeOnClient)
					AND (t.daysOfWeek & @dayOnClient) > 0
					AND @currentTime between startTime and endTime

					)
					begin
						return 1
					end
					else
					begin
						return 0
					end
				end
			return 0
			end



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2FUNC_CheckForPruningOpWindowOnMA]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2FUNC_CheckForPruningOpWindowOnMA' AND revision = '')

  insert into GXDBVersions values(5, 'MMS2FUNC_CheckForPruningOpWindowOnMA',  '', 'MMS2FUNC_CheckForPruningOpWindowOnMA', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
