

--  ------------  Generated from [../../../Source/CommServer/Db/Function/LongRunJobs.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: LongRunJobs'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LongRunJobs]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[LongRunJobs]
  delete from GXDBVersions where name = 'LongRunJobs' and type = 5
END
GO

 CREATE FUNCTION LongRunJobs(
	@TimeRangeBegin	INTEGER,
	@TimeRangeEnd	INTEGER,
	@LongRunHours	INTEGER,
	@TopN			INTEGER,
	@BackupType		VARCHAR(32),
	@ActiveJobsOnly	INTEGER,
	@CountAgedJobs	INTEGER
	)
 RETURNS @Results TABLE (
	JobId			INT,
	CommServer		NVARCHAR(256),
	Client			NVARCHAR(256),
	iDA				NVARCHAR(256),
	Instance		NVARCHAR(256),
	Backupset		NVARCHAR(256),
	Subclient		NVARCHAR(256),
	BackupType		NVARCHAR(32),
	StartTime		NVARCHAR(32),
	EndTime			NVARCHAR(32),
	DurationHr		DECIMAL(10,2),
	Status			NVARCHAR(32),
	AppSizeGB		DECIMAL(20,2),
	TimeZone		NVARCHAR(256)
 )
 AS
 BEGIN

 IF @TimeRangeEnd <= 0
	SET @TimeRangeEnd = 0x7FFFFFFF

 IF	@TopN <= 0
 	SET @TopN = 0x7FFFFFFF

 DECLARE @tblBackupLevel TABLE (BackupLevel INT)

 IF @BackupType = 'Full'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(1)
	INSERT INTO @tblBackupLevel VALUES(1024)
	INSERT INTO @tblBackupLevel VALUES(32768)
 END
 ELSE IF @BackupType LIKE '%Synth%'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(64)
	INSERT INTO @tblBackupLevel VALUES(16384)
 END
 ELSE IF @BackupType LIKE '%Incr%'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(2)
	INSERT INTO @tblBackupLevel VALUES(4)
	INSERT INTO @tblBackupLevel VALUES(128)
	INSERT INTO @tblBackupLevel VALUES(256)
 END
 ELSE
	SET @BackupType = ''

 DECLARE @tblJobs TABLE (jobId INT, appId INT, backupLevel INT, startTime INT, endTime INT, duration INT,
						status VARCHAR(256), appSize BIGINT)

 DECLARE @now INT = dbo.GetUnixTime(GETUTCDATE())

 DECLARE @csName	 VARCHAR(256)
 DECLARE @csTimeZone VARCHAR(256)

 SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2

 SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
 WHERE	TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)

 IF @ActiveJobsOnly = 0
 INSERT	INTO @tblJobs
 SELECT	TOP (@topN) jobId, appId, bkpLevel, servStartDate, servEndDate, (servEndDate - servStartDate),
		dbo.GetJobStatusName(status), totalUncompBytes
 FROM	JMBkpStats
 WHERE	servEndDate BETWEEN @TimeRangeBegin AND @TimeRangeEnd
  	AND status IN (1, 3, 14) and opType IN (4, 14, 76) AND commCellId = 2
  	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700
  	AND (@BackupType = '' OR bkpLevel IN (SELECT BackupLevel FROM @tblBackupLevel))
  	AND (@CountAgedJobs = 1 OR dataStatus = 0)
 ORDER BY (servEndDate - servStartDate) DESC

 INSERT	INTO @tblJobs
 SELECT	TOP (@topN) B.jobId, B.applicationId, B.bkpLevel, J.jobStartTime, 0, (@now - J.jobStartTime),
		dbo.GetJobStateName(J.state), B.unCompBytes
 FROM	JMBkpJobInfo B INNER JOIN JMJobInfo J ON J.jobId = B.jobId AND J.commCellId = B.commcellId
 WHERE (@BackupType = '' OR bkpLevel IN (SELECT BackupLevel FROM @tblBackupLevel))
 ORDER BY J.jobStartTime

 INSERT	INTO @Results
 SELECT	TOP (@topN) J.jobId, @csName, CL.name, IT.name, I.name, BS.name, A.subclientName,
		dbo.GetJobBackupTypeDisplay(J.backupLevel),
		dbo.UTCToLocalStringTime(dbo.GetDateTime(startTime), @csTimeZone),
		CASE WHEN endTime > 0 THEN dbo.UTCToLocalStringTime(dbo.GetDateTime(endTime), @csTimeZone) ELSE 'N/A' END,
		ROUND(J.duration/3600.0, 2), J.status, ROUND(appSize/1024.0/1024.0/1024.0, 2), @csTimeZone
 FROM	@tblJobs J
 		INNER JOIN APP_Application A ON A.id = J.appId
 		INNER JOIN APP_Client CL ON CL.id = A.clientId
 		INNER JOIN APP_iDAType IT ON IT.type = A.appTypeId
 		INNER JOIN APP_InstanceName I ON I.id = A.instance
 		INNER JOIN APP_BackupsetName BS ON BS.id = A.backupset
 WHERE	J.duration > @LongRunHours*3600
 ORDER BY J.duration DESC

 RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [LongRunJobs]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'LongRunJobs' AND revision = '1.3.198.1')

  insert into GXDBVersions values(5, 'LongRunJobs',  '1.3.198.1', 'LongRunJobs', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
