

--  ------------  Generated from [../../../Source/CommServer/Db/Function/LeastDedupedJobs.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: LeastDedupedJobs'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LeastDedupedJobs]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[LeastDedupedJobs]
  delete from GXDBVersions where name = 'LeastDedupedJobs' and type = 5
END
GO

 CREATE FUNCTION LeastDedupedJobs(
	@TimeRangeBegin	INTEGER,
	@TimeRangeEnd	INTEGER,
	@LowDedupePct	INTEGER,
	@TopN			INTEGER,
	@BackupType		VARCHAR(32),
	@CountAgedJobs	INTEGER
	)
 RETURNS @Results TABLE (
	JobId			INT,
	CommServer		NVARCHAR(256),
	Client			NVARCHAR(256),
	iDA				NVARCHAR(256),
	Instance		NVARCHAR(256),
	Backupset		NVARCHAR(256),
	Subclient		NVARCHAR(256),
	StoragePolicy	NVARCHAR(256),
	Copy			NVARCHAR(256),
	AppSizeGB		DECIMAL(20,2),
	DedupeRatio		DECIMAL(20,2),
	BackupType		NVARCHAR(32),
	StartTime		NVARCHAR(32),
	EndTime			NVARCHAR(32),
	Status			NVARCHAR(32),
	DedupeStoreName	NVARCHAR(256),
	FirstBackupTime	NVARCHAR(32),
	TimeZone		NVARCHAR(256)
 )
 AS
 BEGIN

 IF @TimeRangeEnd <= 0
	SET @TimeRangeEnd = 0x7FFFFFFF

 IF	@TopN <= 0
 	SET @TopN = 0x7FFFFFFF

 DECLARE @tblBackupLevel TABLE (BackupLevel INT)

 IF @BackupType = 'Full'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(1)
	INSERT INTO @tblBackupLevel VALUES(1024)
	INSERT INTO @tblBackupLevel VALUES(32768)
 END
 ELSE IF @BackupType LIKE '%Synth%'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(64)
	INSERT INTO @tblBackupLevel VALUES(16384)
 END
 ELSE IF @BackupType LIKE '%Incr%'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(2)
	INSERT INTO @tblBackupLevel VALUES(4)
	INSERT INTO @tblBackupLevel VALUES(128)
	INSERT INTO @tblBackupLevel VALUES(256)
 END
 ELSE
	SET @BackupType = ''

 DECLARE @csName	 VARCHAR(256)
 DECLARE @csTimeZone VARCHAR(256)

 SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2

 SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
 WHERE	TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)

 DECLARE @tblJobs TABLE (jobId INT, commCellId INT, appId INT, archGrpId INT, archGrpCopyId INT,
						appSizeGB DECIMAL(20,2), dedupeRatio DECIMAL(20,2), backupLevel INT,
						startTime INT, endTime INT, status INT, SIDBStoreId INT)

 INSERT	INTO @tblJobs
 SELECT	TOP (@topN) D.jobId, D.commCellId, D.appId, D.archGrpId, D.archGrpCopyId, ROUND(B.totalUncompBytes/1024.0/1024.0/1024.0, 2),
 		DedupeRatio = CASE WHEN (B.totalUncompBytes - D.sizeOnMedia) <= 0 THEN 0
 					ELSE ROUND(100.0*(B.totalUncompBytes - D.sizeOnMedia)/B.totalUncompBytes, 2) END,
 		B.bkpLevel, B.servStartDate, B.servEndDate, B.status, 0
 FROM	JMJobDataStats D
 		INNER JOIN archGroupCopy C ON C.id = D.archGrpCopyId
 		INNER JOIN JMBkpStats B ON B.jobId = D.jobId AND B.commCellId = D.commCellId
 WHERE	D.dataType IN (1, 4) AND D.status = 100 AND (@CountAgedJobs = 1 OR (D.disabled & 256) = 0)
 	AND (C.dedupeFlags & 262144) > 0
 	AND B.servEndDate BETWEEN @TimeRangeBegin AND @TimeRangeEnd
  	AND B.status IN (1, 3, 14) and B.opType IN (4, 14, 76) AND B.commCellId = 2
  	AND B.appType < 1000 AND B.appType NOT BETWEEN 600 AND 700
  	AND (@BackupType = '' OR bkpLevel IN (SELECT BackupLevel FROM @tblBackupLevel))
 	AND B.totalUncompBytes > 0 AND 100.0*(B.totalUncompBytes - D.sizeOnMedia)/B.totalUncompBytes < @LowDedupePct
 ORDER BY DedupeRatio

 UPDATE	@tblJobs
 SET	SIDBStoreId = T.SIDBStoreId
 FROM	@tblJobs J INNER JOIN
 		(SELECT	A.jobId, A.commCellId, A.archGrpCopyId, MAX(AFC.SIDBStoreId) AS SIDBStoreId
 		FROM	@tblJobs A INNER JOIN archFile AF
 					ON AF.jobId = A.jobId AND AF.commCellId = A.commCellId
 				INNER JOIN archFileCopyDedup AFC
 					ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = A.archGrpCopyId
 		GROUP BY A.jobId, A.commCellId, A.archGrpCopyId) T
 	ON	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.archGrpCopyId = T.archGrpCopyId

 INSERT	INTO @Results
 SELECT	J.jobId, @csName, CL.name, IT.name, I.name, BS.name, A.subclientName, AG.name, AGC.name, appSizeGB, dedupeRatio,
		dbo.GetJobBackupTypeDisplay(J.backupLevel),
		dbo.UTCToLocalStringTime(dbo.GetDateTime(J.startTime), @csTimeZone),
		dbo.UTCToLocalStringTime(dbo.GetDateTime(J.endTime), @csTimeZone),
		dbo.GetJobStatusName(J.status), S.SIDBStoreName,
		dbo.UTCToLocalStringTime(dbo.GetDateTime(S.FirstBackupTime), @csTimeZone), @csTimeZone
 FROM	@tblJobs J
 		INNER JOIN APP_Application A ON A.id = J.appId
 		INNER JOIN APP_Client CL ON CL.id = A.clientId
 		INNER JOIN APP_iDAType IT ON IT.type = A.appTypeId
 		INNER JOIN APP_InstanceName I ON I.id = A.instance
 		INNER JOIN APP_BackupsetName BS ON BS.id = A.backupset
 		INNER JOIN archGroup AG ON AG.id = J.archGrpId
 		INNER JOIN archGroupCopy AGC ON AGC.id = J.archGrpCopyId
 		INNER JOIN IdxSIDBStore S ON S.SIDBStoreId = J.SIDBStoreId

 RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [LeastDedupedJobs]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'LeastDedupedJobs' AND revision = '1.3.198.2')

  insert into GXDBVersions values(5, 'LeastDedupedJobs',  '1.3.198.2', 'LeastDedupedJobs', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
