

--  ------------  Generated from [../../../Source/CommServer/Db/Function/LargestClients.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: LargestClients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LargestClients]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[LargestClients]
  delete from GXDBVersions where name = 'LargestClients' and type = 5
END
GO

 CREATE FUNCTION LargestClients(
	@TimeRangeBegin	INTEGER,
	@TimeRangeEnd	INTEGER,
	@TopN			INTEGER,
	@CountAgedJobs	INTEGER
 )
 RETURNS @Results TABLE (
	CommServer		NVARCHAR(256),
	Client			NVARCHAR(256),
	AppSizeGB		DECIMAL(20,2),
	ShareOfTotal	DECIMAL(20,2),
	TotalSizeGB		DECIMAL(20,2)
 )
 AS
 BEGIN

 DECLARE @csName	VARCHAR(256) = (SELECT aliasName FROM APP_CommCell WHERE id = 2)

 DECLARE @TotalSize	BIGINT

 IF @TimeRangeEnd <= 0
	SET @TimeRangeEnd = 0x7FFFFFFF

 IF	@TopN <= 0
 	SET @TopN = 0x7FFFFFFF

 DECLARE @tblClientSize TABLE (ClientId INT, AppSize BIGINT)

 INSERT	INTO @tblClientSize
 SELECT	clientId, SUM(totalUnCompBytes)
 FROM	APP_Application A INNER JOIN JMBkpStats B ON A.id = B.appId
 WHERE	servEndDate BETWEEN @TimeRangeBegin AND @TimeRangeEnd
 	AND status IN (1, 3, 14) and opType IN (4, 14, 76) AND commCellId = 2
 	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700
 	AND (@CountAgedJobs = 1 OR dataStatus = 0)
 GROUP BY clientId

 SET	@TotalSize = (SELECT SUM(AppSize) FROM @tblClientSize)

 INSERT	INTO @Results
 SELECT	TOP (@TopN)
 		@csName AS CommServer,
 		name AS Client,
 		ROUND(AppSize/1024.0/1024.0/1024.0, 2) AS SizeGB,
 		ROUND(100.0*AppSize/@TotalSize, 2) AS ShareOfTotal,
 		ROUND(@TotalSize/1024.0/1024.0/1024.0, 2) AS TotalSizeGB
 FROM	@tblClientSize S INNER JOIN APP_Client C ON C.id = S.ClientId
 ORDER BY AppSize DESC

 RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [LargestClients]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'LargestClients' AND revision = '1.3.198.1')

  insert into GXDBVersions values(5, 'LargestClients',  '1.3.198.1', 'LargestClients', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
