

--  ------------  Generated from [../../../Source/CommServer/Db/Function/LargestClientDataOnMedia.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: LargestClientDataOnMedia'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LargestClientDataOnMedia]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[LargestClientDataOnMedia]
  delete from GXDBVersions where name = 'LargestClientDataOnMedia' and type = 5
END
GO

 CREATE FUNCTION LargestClientDataOnMedia (
	@TopN			INTEGER,
	@CountAgedJobs	INTEGER
 )
 RETURNS @Results TABLE (
	Client			NVARCHAR(256),
	SizeOnMediaGB	DECIMAL(20,2),
	ShareOfTotal	DECIMAL(20,2),
	TotalSizeGB		DECIMAL(20,2)
 )
 AS
 BEGIN

 DECLARE @TotalSize	BIGINT

 IF	@TopN <= 0
 	SET @TopN = 0x7FFFFFFF

 DECLARE @tblClientSize TABLE (ClientId INT, SizeOnMedia BIGINT)

 INSERT	INTO @tblClientSize
 SELECT	A.clientId, SUM(J.sizeOnMedia)
 FROM	APP_Application A INNER JOIN JMJobDataStats J ON J.appId = A.id
 WHERE	J.status IN (100, 102, 103) AND ((J.disabled & 256) = 0 OR @CountAgedJobs = 1)
 GROUP BY A.clientId

 SET	@TotalSize = (SELECT SUM(SizeOnMedia) FROM @tblClientSize)

 INSERT	INTO @Results
 SELECT	TOP (@TopN)
 		name AS Client,
 		ROUND(SizeOnMedia/1024.0/1024.0/1024.0, 2) AS SizeOnMediaGB,
 		ROUND(100.0*SizeOnMedia/@TotalSize, 2) AS ShareOfTotal,
 		ROUND(@TotalSize/1024.0/1024.0/1024.0, 2) AS TotalSizeGB
 FROM	@tblClientSize S INNER JOIN APP_Client C ON C.id = S.ClientId
 ORDER BY SizeOnMedia DESC

 RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [LargestClientDataOnMedia]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'LargestClientDataOnMedia' AND revision = '1.2.192.1')

  insert into GXDBVersions values(5, 'LargestClientDataOnMedia',  '1.2.192.1', 'LargestClientDataOnMedia', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
