

--  ------------  Generated from [../../../Source/CommServer/Db/Function/JMIsOpTypeEnabled.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: JMIsOpTypeEnabled'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMIsOpTypeEnabled]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[JMIsOpTypeEnabled]
  delete from GXDBVersions where name = 'JMIsOpTypeEnabled' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION JMIsOpTypeEnabled(@inOpType int, @inEntityType INT, @inEntityId int = 0,  @inAppType INT = 0)
RETURNS INTEGER
AS
BEGIN
	DECLARE @defaultAppId INT, @defaultInstanceId INT
	SELECT TOP 1 @defaultAppId = id, @defaultInstanceId = instance FROM APP_Application WHERE appTypeId = 1000 /* CV_APPTYPE_COMMSRVMGMT */
	-- check if "All Activity" for entire server is disabled
	IF EXISTS (SELECT 1 FROM JMJobAction WHERE action = 1 /* DISABLEACTIVITY */ AND clientId = 1 AND appType = 0 AND mediaAgentID = 1 AND opType = 1 /* ALLOPS */ and appId = @defaultAppId AND clientGroupId = 0 AND instanceid = @defaultInstanceId)
	BEGIN
		RETURN 0
	END
	-- following types, only "All Activity" should be checked
	IF @inOpType = 1 /* ALLOPS */ OR @inOpType = 33 /* SHELFMANAGEMENT */ OR @inOpType = 21 /* MEDIAINVENTORY */
		OR @inOpType = 20 /* SCHEDEXPORT */ OR  @inOpType = 17 /* REPORT */ OR @inOpType = 38 /* SELECTIVEDELETE */
		OR @inOpType = 11 /* CSDRBKP */
	BEGIN
		RETURN 1
	END
	-- check if entire server is disabled for the OpType
	IF EXISTS (SELECT 1 FROM JMJobAction WHERE action = 1 /* DISABLEACTIVITY */ AND clientId = 1 AND appType = 0 AND mediaAgentID = 1 AND opType = @inOpType and appId = @defaultAppId AND clientGroupId = 0 AND instanceid = @defaultInstanceId)
	BEGIN
		RETURN 0
	END
	-- if only server level needs to be checked
	IF @inEntityType = 1 /* COMMCELL_ENTITY */ OR @inEntityType = 2 /* ALL_CLIENTS */
	BEGIN
		RETURN 1
	END
	-- following admin job opTypes, only server level should be checked
	IF @inOpType = 13 /* AUXCOPY */ OR @inOpType = 104 /* AUXCOPY2 (DASH) */
		OR @inOpType = 74 /* MEDIAREFRESHING */ OR @inOpType = 127 /* MEDIAREFRESHING2 */ OR @inOpType = 10 /* PRUNE */
		OR @inOpType = 32 /* TAPEERASE */ OR  @inOpType = 31 /* ARCHIVECHECK */ OR  @inOpType = 106 /* ARCHIVECHECK2 (DASH) */
		OR @inOpType = 53 /* OFFLINECONTENTINDEX */ OR @inOpType = 99 /* MOVEDDB */ OR @inOpType = 100 /* DDBOPS */
		OR @inOpType = 141 /* DDB_SPACE_RECLAMATION */ OR @inOpType = 35 /* PATCHUPDATE */ OR @inOpType = 36 /* PATCHDOWNLOAD */
	BEGIN
		RETURN 1
	END
	-- check if appType is diesabled at server level
	IF @inAppType <> 0 AND EXISTS (SELECT 1 FROM JMJobAction WHERE action = 1 /* DISABLEACTIVITY */ AND clientId = 1 AND appType = @inAppType AND mediaAgentID = 1 AND opType = @inOpType and appId = @defaultAppId AND clientGroupId = 0 AND instanceid = @defaultInstanceId)
	BEGIN
		RETURN 0
	END
	-- check client group level
	IF (@inEntityType = 7 /* SUBCLIENT_ENTITY  */ AND
		EXISTS ( SELECT 1 FROM JMJobAction WHERE action = 1 /* DISABLEACTIVITY */ AND clientId = 1 AND appType = 0 AND mediaAgentID = 1 AND opType = @inOpType and appId = @defaultAppId AND instanceid = @defaultInstanceId
			AND clientGroupId IN (SELECT cg.id FROM APP_ClientGroup cg WITH(NOLOCK) WHERE cg.id > 0 AND cg.id IN (
				SELECT cga.clientGroupId FROM APP_ClientGroupAssoc cga WITH(NOLOCK) WHERE cga.clientId = (SELECT TOP 1 clientid from APP_Application where id = @inEntityId))) ))
		OR (@inEntityType = 3 /* CLIENT_ENTITY  */ AND
		EXISTS ( SELECT 1 FROM JMJobAction WHERE action = 1 /* DISABLEACTIVITY */ AND clientId = 1 AND appType = 0 AND mediaAgentID = 1 AND opType = @inOpType and appId = @defaultAppId AND instanceid = @defaultInstanceId
			AND clientGroupId IN (SELECT cg.id FROM APP_ClientGroup cg WITH(NOLOCK) WHERE cg.id > 0 AND cg.id IN (
				SELECT cga.clientGroupId FROM APP_ClientGroupAssoc cga WITH(NOLOCK) WHERE cga.clientId = @inEntityId )) ))
	BEGIN
		RETURN 0
	END
	-- check subclient policy level
	IF (@inEntityType = 7 /* SUBCLIENT_ENTITY  */ AND
		EXISTS ( SELECT 1 FROM JMJobAction WHERE action = 1 /* DISABLEACTIVITY */ AND clientId = 1 AND appType = 0 AND mediaAgentID = 1 AND opType = @inOpType  AND clientGroupId = 0 AND instanceid = @defaultInstanceId
			AND appId IN (select attrVal from APP_SubClientProp where componentNameId = @inEntityId and modified = 0 and attrName = 'Associated subclient Policy')))
	BEGIN
		RETURN 0
	END
	-- check at client level
	IF (@inEntityType = 3 /* CLIENT_ENTITY  */ AND
			EXISTS ( SELECT 1 FROM JMJobAction WHERE action = 1 /* DISABLEACTIVITY */ AND clientId = @inEntityId AND appType = 0 AND mediaAgentID = 1 AND opType = @inOpType  AND clientGroupId = 0 AND instanceid = @defaultInstanceId
			AND appId = @defaultAppId))
		OR (@inEntityType = 7 /* SUBCLIENT_ENTITY  */ AND
			EXISTS ( SELECT 1 FROM JMJobAction WHERE action = 1 /* DISABLEACTIVITY */ AND clientId = (SELECT TOP 1 clientid from APP_Application where id = @inEntityId) AND appType = 0 AND mediaAgentID = 1 AND opType = @inOpType  AND clientGroupId = 0 AND instanceid = @defaultInstanceId
			AND appId = @defaultAppId))
	BEGIN
		RETURN 0
	END
	-- check if appType is disabled at client level
	IF @inAppType <> 0 AND (
		(@inEntityType = 3 /* CLIENT_ENTITY  */ AND
			EXISTS ( SELECT 1 FROM JMJobAction WHERE action = 1 /* DISABLEACTIVITY */ AND clientId = @inEntityId AND appType = @inAppType AND mediaAgentID = 1 AND opType = @inOpType  AND clientGroupId = 0 AND instanceid = @defaultInstanceId
			AND appId = @defaultAppId))
		OR (@inEntityType = 7 /* SUBCLIENT_ENTITY  */ AND
			EXISTS ( SELECT 1 FROM JMJobAction WHERE action = 1 /* DISABLEACTIVITY */ AND clientId = (SELECT TOP 1 clientid from APP_Application where id = @inEntityId) AND appType = @inAppType AND mediaAgentID = 1 AND opType = @inOpType  AND clientGroupId = 0 AND instanceid = @defaultInstanceId
			AND appId = @defaultAppId)))
	BEGIN
		RETURN 0
	END
	-- check if instance level needs to be checked
	IF @inAppType <> 0 AND dbo.JMAppTypeNeedInstance(@inAppType) = 1
		AND @inEntityType = 7 /* SUBCLIENT_ENTITY  */ AND
			EXISTS ( SELECT 1 FROM JMJobAction WHERE action = 1 /* DISABLEACTIVITY */ AND clientId = 1 AND appType = 0 AND mediaAgentID = 1 AND opType = @inOpType  AND clientGroupId = 0 AND appId = @defaultAppId
			AND instanceid = (SELECT TOP 1 instance from APP_Application where id = @inEntityId))
	BEGIN
		RETURN 0
	END
	-- restore job activity then no need to check the subclient activity
	IF @inOpType = 5 /* RESTORE */
	BEGIN
		RETURN 1
	END
	IF @inEntityType = 7 /* SUBCLIENT_ENTITY  */
		AND EXISTS (SELECT 1 FROM JMJobAction WHERE action = 1 /* DISABLEACTIVITY */ AND clientId = 1 AND appType = 0 AND mediaAgentID = 1 AND opType = @inOpType and appId = @inEntityId)
	BEGIN
		RETURN 0
	END
	-- potential OCS checking here
	return 1 -- by default, opType should be enabled
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [JMIsOpTypeEnabled]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'JMIsOpTypeEnabled' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'JMIsOpTypeEnabled',  '1.1.2.1', 'JMIsOpTypeEnabled', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
