

--  ------------  Generated from [../../../Source/CommServer/Db/Function/JMGetLocalizedMessageMaxImpl.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: JMGetLocalizedMessageMaxImpl'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMGetLocalizedMessageMaxImpl]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[JMGetLocalizedMessageMaxImpl]
  delete from GXDBVersions where name = 'JMGetLocalizedMessageMaxImpl' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION JMGetLocalizedMessageMaxImpl(@localeId integer, @inputMsgs varchar(256), @returnSourceAndProcessInfo bit = 1)
RETURNS NVARCHAR(MAX)
-- WITH ENCRYPTION
AS
BEGIN
	DECLARE @messages varchar(256)
	DECLARE @msgId varchar(40)
	DECLARE @endIndex integer
	DECLARE @startIndex integer
	DECLARE @EventId integer
	DECLARE @output nvarchar(MAX)
	DECLARE @MsgTxt nvarchar(MAX)
	DECLARE @subSystemName varchar(64)
	DECLARE @machineName varchar(64)
	SET @startIndex = 0
	SET @messages = @inputMsgs
	SET @output = N''
	SET @endIndex = CHARINDEX(',', @messages, @startIndex)
	IF (@endIndex is NULL OR @endIndex = 0)
	BEGIN
		SET @output = @messages
	END
	ELSE
	BEGIN
		WHILE(@endIndex IS NOT NULL AND @endIndex <> 0)
		BEGIN
			SET @EventId = 0
			SET @msgId = SUBSTRING(@messages,@startIndex,@endIndex-@startIndex)
			SELECT @EventId = messageId, @subSystemName = subsystem, @machineName = client  FROM JMFailureReasonMsg WITH (READUNCOMMITTED) WHERE id = @msgId
			if (@EventId IS NOT null AND @EventId <> 0)
			BEGIN
				SET @MsgTxt = DBO.JMFormatPendingMsgText( @msgId, @localeId, @EventId, 1)
				IF @returnSourceAndProcessInfo = 1 AND LEN(@machineName) <> 0
				BEGIN
					SET @MsgTxt = @MsgTxt + '<br>Source: ' + @machineName
					IF LEN(@subSystemName) <> 0
						SET @MsgTxt = @MsgTxt + ', Process: ' + @subSystemName
				END
				IF @MsgTxt IS NOT null
				BEGIN
					IF LEN(@output) <> 0 BEGIN
						SET @output = @output + '<br>' + '<br>'
					END
					SET @MsgTxt = REPLACE(@MsgTxt, NCHAR(10), NCHAR(13))
					SET @output = @output + @MsgTxt
				END
			END
			SET @startIndex = @endIndex + 1
			SET @endIndex = CHARINDEX(',', @messages, @startIndex)
		END
	END
	RETURN @output
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [JMGetLocalizedMessageMaxImpl]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'JMGetLocalizedMessageMaxImpl' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'JMGetLocalizedMessageMaxImpl',  '1.1.2.1', 'JMGetLocalizedMessageMaxImpl', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
