

--  ------------  Generated from [../../../Source/CommServer/Db/Function/JMGetKBArticlesForFailures.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: JMGetKBArticlesForFailures'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMGetKBArticlesForFailures]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[JMGetKBArticlesForFailures]
  delete from GXDBVersions where name = 'JMGetKBArticlesForFailures' and type = 5
END
GO

    CREATE FUNCTION [dbo].[JMGetKBArticlesForFailures]
    (
    	@failureReasonsList NVARCHAR(256),
    	@localeId			int = 0

    )
    RETURNS NVARCHAR(1024)
    AS
    BEGIN
       	DECLARE @startIndex		AS INT
       	DECLARE @endIndex		AS INT
       	DECLARE @retval			NVARCHAR(1024)
       	DECLARE @reasonId		BIGINT
       	DECLARE @msgId			bigint

       	DECLARE @cliVer			AS INT
       	DECLARE @serVer			AS INT
       	DECLARE @iDa			AS INT
       	DECLARE @opType			AS INT
       	DECLARE @phaseNum		AS INT
    	DECLARE @customMsgId	bigint

       	DECLARE @nameOpPhase	AS NVARCHAR(256)
       	DECLARE @opTableId		AS INT

       	SET @startIndex = 1
       	SET @endIndex   = 0
       	SET @retval		= N''

       	SET @retval = N''

       	if LEN(@failureReasonsList) > 0 BEGIN

       		SET @endIndex = CHARINDEX(',', @failureReasonsList, @startIndex)
       		IF  @endIndex IS NOT NULL AND @endIndex <> 0 BEGIN
       			WHILE @endIndex IS NOT NULL AND @endIndex <> 0 BEGIN
       				SET @reasonId = CONVERT( BIGINT, SUBSTRING(@failureReasonsList, @startIndex, @endIndex - @startIndex) )

       				SELECT @msgId		= JMFailureReasonMsg.messageId,
       					   @cliVer		= JMFailureReasonMsg.clientVersion,
       					   @serVer		= JMFailureReasonMsg.serverVersion,
       					   @iDa			= JMFailureReasonMsg.iDA,
       					   @opType		= JMFailureReasonMsg.opType,
       					   @phaseNum	= JMFailureReasonMsg.phaseNumber,
       					   @customMsgId = JMFailureReasonMsg.customMessageId

       				FROM   JMFailureReasonMsg WITH (READUNCOMMITTED) INNER JOIN EvLocaleMsgs WITH (READUNCOMMITTED) ON JMFailureReasonMsg.messageId = EvLocaleMsgs.MessageID
       				WHERE  (EvLocaleMsgs.hasKBArticle = 1)     AND
                           (EvLocaleMsgs.LocaleID = @localeId) AND
                           (JMFailureReasonMsg.id = @reasonId)

       				IF @msgId IS NOT NULL BEGIN
       					IF LEN( @retval ) > 0
       						SET @retval = @retval + ':'

       					IF @cliVer IS NOT NULL
       						SET @retval = @retval + N'cliver=' + CAST(@cliVer as NVARCHAR)     + CHAR(13)

       					IF @serVer IS NOT NULL
       						SET @retval = @retval + N'server=' + CAST(@serVer as NVARCHAR)     + CHAR(13)

       					IF 	@iDa IS NOT NULL
       						SET @retval = @retval + N'ida=' + CAST(@iDa as NVARCHAR)           + CHAR(13)

    					IF @opType IS NOT NULL
       						SET @retval = @retval + N'opType=' + CAST(@opType AS NVARCHAR) + CHAR(13)

    					IF @phaseNum IS NOT NULL
    						SET @retval = @retval + N'phaseNum=' + CAST(@phaseNum AS NVARCHAR) + CHAR(13)

       					SET @retval = @retval + N'messageId=' + CAST( @msgId AS NVARCHAR ) + CHAR(13)

    					SET @retval = @retval + N'customMessageId=' + CAST(@customMsgId AS NVARCHAR) + N';'

       				END

       				SET @msgId		 = NULL
       				SET @cliVer		 = NULL
       				SET @serVer		 = NULL
       				SET @iDa		 = NULL
       				SET @opType		 = NULL
       				SET @phaseNum	 = NULL
    				SET @customMsgId = NULL

       				SET @startIndex = @endIndex + 1
       				SET @endIndex = CHARINDEX(',', @failureReasonsList, @startIndex)
       			END
       		END

       	END

       	return @retval;

       END





GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [JMGetKBArticlesForFailures]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'JMGetKBArticlesForFailures' AND revision = '1.3.302.1')

  insert into GXDBVersions values(5, 'JMGetKBArticlesForFailures',  '1.3.302.1', 'JMGetKBArticlesForFailures', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
