

--  ------------  Generated from [../../../Source/CommServer/Db/Function/JMFormatPendingMsgText.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: JMFormatPendingMsgText'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMFormatPendingMsgText]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[JMFormatPendingMsgText]
  delete from GXDBVersions where name = 'JMFormatPendingMsgText' and type = 5
END
GO

	CREATE FUNCTION JMFormatPendingMsgText ( @MsgId INTEGER, @LocaleId INTEGER, @EventId INTEGER, @UniqPosition INTEGER )
	RETURNS NVARCHAR(1024)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @MsgTxt		NVARCHAR(4000)
		DECLARE @Data		NVARCHAR(4000)
		DECLARE @MsgTxtTmp	NVARCHAR(4000)
		DECLARE @ArgPos		INTEGER
		DECLARE @ArgIndex	INTEGER
		DECLARE @DataType	INTEGER
		DECLARE @HexFlag	INTEGER
		DECLARE @FullFmtSpecLen	INTEGER
		DECLARE @ParentMask	INTEGER

		SELECT @MsgTxt = Message
		FROM EvLocaleMsgs
		WHERE MessageId = @EventId
		AND LocaleId = @LocaleId

		IF @MsgTxt is null
		BEGIN
			SET @LocaleId = 0				-- If message id not found then try English

			SELECT @MsgTxt = Message
				FROM EvLocaleMsgs WITH (READUNCOMMITTED)
				WHERE MessageId = @EventId
				AND LocaleId = @LocaleId

			IF @MsgTxt is null			-- If even English message not found then error out
			BEGIN
				RETURN @MsgTxt
			END
		END

		SET @ParentMask = @UniqPosition & 0xFFFFFFF0

		DECLARE GetTextPos CURSOR
		FOR	SELECT ArgPos, ArgIndex, DataType, HexFlag, FullFmtSpecLen
			FROM EvLocaleMsgArgInfo WITH (READUNCOMMITTED)
			WHERE MessageId = @EventId
			AND LocaleId = @LocaleId
			ORDER BY ArgIndex DESC
		FOR READ ONLY

		OPEN GetTextPos

		FETCH NEXT FROM GetTextPos
		INTO @ArgPos, @ArgIndex, @DataType, @HexFlag, @FullFmtSpecLen

		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @UniqPosition = @ParentMask + @ArgPos

			SELECT @Data = Data FROM JMFailureReasonMsgParam WITH (READUNCOMMITTED) WHERE MsgId = @MsgId AND Position = @UniqPosition

			IF @DataType = 13		-- Event, Now recurse
				SET @MsgTxtTmp = dbo.JMFormatPendingMsgText(@MsgId, @LocaleId, CAST(@Data AS INTEGER), (@UniqPosition*16))
			ELSE IF @HexFlag = 1
				SET @MsgTxtTmp = dbo.ConvertBigIntToHexStr(CAST(@Data AS bigint))
			ELSE
				SET @MsgTxtTmp = @Data

			SET @Data = STUFF(@MsgTxt, @ArgIndex, @FullFmtSpecLen, @MsgTxtTmp)
			SET @MsgTxt = @Data		-- Putting this in one statement did not work, something gets overwritten


			FETCH NEXT FROM GetTextPos
			INTO @ArgPos, @ArgIndex, @DataType, @HexFlag, @FullFmtSpecLen
		END

		CLOSE GetTextPos
		DEALLOCATE GetTextPos

		RETURN @MsgTxt
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [JMFormatPendingMsgText]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'JMFormatPendingMsgText' AND revision = '1.3.304.1')

  insert into GXDBVersions values(5, 'JMFormatPendingMsgText',  '1.3.304.1', 'JMFormatPendingMsgText', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
