

--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsSubClientValid.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsSubClientValid'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsSubClientValid]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsSubClientValid]
  delete from GXDBVersions where name = 'IsSubClientValid' and type = 5
END
GO

	CREATE FUNCTION IsSubClientValid (@AppTypeID int, @SubClientStatus int, @ForJobsOnly int = 0)
	RETURNS INT
	-- WITH ENCRYPTION
	BEGIN
		RETURN CASE WHEN (@AppTypeID in (58) AND (@SubClientStatus & 0x400 = 0x400)) THEN 1
			        WHEN ((@AppTypeID in (24, 25, 40, 47, 48, 50, 65, 66, 67, 68, 73, 75, 76) AND
			             (@SubClientStatus & 0x8) = 0x8) OR
			             (@AppTypeID in (72, 85, 127)) OR
			             (@AppTypeID in (84, 107) AND @ForJobsOnly = 0) OR
			             (@AppTypeID in (121, 122)) OR
			             (@AppTypeID BETWEEN 600 AND 700) OR
			             (@AppTypeID >= 1000) ) THEN 0
		        	WHEN (@SubClientStatus & 0x10 = 0x10) OR        -- CV_STATUS_DUMMY
		             	 (@SubClientStatus & 0x20 = 0x20)           -- CV_STATUS_HIDDEN
		                 THEN 0
				    ELSE 1
			    END
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsSubClientValid]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsSubClientValid' AND revision = '1.6.88.2')

  insert into GXDBVersions values(5, 'IsSubClientValid',  '1.6.88.2', 'IsSubClientValid', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
